/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyEventAdjustPoints {
    private final Optional<String> loyaltyProgramId;
    private final int points;
    private final Optional<String> reason;
    private final Map<String, Object> additionalProperties;

    private LoyaltyEventAdjustPoints(Optional<String> loyaltyProgramId, int points, Optional<String> reason, Map<String, Object> additionalProperties) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.points = points;
        this.reason = reason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="loyalty_program_id")
    public Optional<String> getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonProperty(value="points")
    public int getPoints() {
        return this.points;
    }

    @JsonIgnore
    public Optional<String> getReason() {
        if (this.reason == null) {
            return Optional.empty();
        }
        return this.reason;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reason")
    private Optional<String> _getReason() {
        return this.reason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyEventAdjustPoints && this.equalTo((LoyaltyEventAdjustPoints)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyEventAdjustPoints other) {
        return this.loyaltyProgramId.equals(other.loyaltyProgramId) && this.points == other.points && this.reason.equals(other.reason);
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.points, this.reason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PointsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PointsStage,
    _FinalStage {
        private int points;
        private Optional<String> reason = Optional.empty();
        private Optional<String> loyaltyProgramId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyEventAdjustPoints other) {
            this.loyaltyProgramId(other.getLoyaltyProgramId());
            this.points(other.getPoints());
            this.reason(other.getReason());
            return this;
        }

        @Override
        @JsonSetter(value="points")
        public _FinalStage points(int points) {
            this.points = points;
            return this;
        }

        @Override
        public _FinalStage reason(Nullable<String> reason) {
            this.reason = reason.isNull() ? null : (reason.isEmpty() ? Optional.empty() : Optional.of(reason.get()));
            return this;
        }

        @Override
        public _FinalStage reason(String reason) {
            this.reason = Optional.ofNullable(reason);
            return this;
        }

        @Override
        @JsonSetter(value="reason", nulls=Nulls.SKIP)
        public _FinalStage reason(Optional<String> reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public _FinalStage loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = Optional.ofNullable(loyaltyProgramId);
            return this;
        }

        @Override
        @JsonSetter(value="loyalty_program_id", nulls=Nulls.SKIP)
        public _FinalStage loyaltyProgramId(Optional<String> loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        @Override
        public LoyaltyEventAdjustPoints build() {
            return new LoyaltyEventAdjustPoints(this.loyaltyProgramId, this.points, this.reason, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyEventAdjustPoints build();

        public _FinalStage loyaltyProgramId(Optional<String> var1);

        public _FinalStage loyaltyProgramId(String var1);

        public _FinalStage reason(Optional<String> var1);

        public _FinalStage reason(String var1);

        public _FinalStage reason(Nullable<String> var1);
    }

    public static interface PointsStage {
        public _FinalStage points(int var1);

        public Builder from(LoyaltyEventAdjustPoints var1);
    }
}

