/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LoyaltyAccountExpiringPointDeadline {
    private final int points;
    private final String expiresAt;
    private final Map<String, Object> additionalProperties;

    private LoyaltyAccountExpiringPointDeadline(int points, String expiresAt, Map<String, Object> additionalProperties) {
        this.points = points;
        this.expiresAt = expiresAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="points")
    public int getPoints() {
        return this.points;
    }

    @JsonProperty(value="expires_at")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LoyaltyAccountExpiringPointDeadline && this.equalTo((LoyaltyAccountExpiringPointDeadline)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LoyaltyAccountExpiringPointDeadline other) {
        return this.points == other.points && this.expiresAt.equals(other.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.points, this.expiresAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PointsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PointsStage,
    ExpiresAtStage,
    _FinalStage {
        private int points;
        private String expiresAt;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LoyaltyAccountExpiringPointDeadline other) {
            this.points(other.getPoints());
            this.expiresAt(other.getExpiresAt());
            return this;
        }

        @Override
        @JsonSetter(value="points")
        public ExpiresAtStage points(int points) {
            this.points = points;
            return this;
        }

        @Override
        @JsonSetter(value="expires_at")
        public _FinalStage expiresAt(@NotNull String expiresAt) {
            this.expiresAt = Objects.requireNonNull(expiresAt, "expiresAt must not be null");
            return this;
        }

        @Override
        public LoyaltyAccountExpiringPointDeadline build() {
            return new LoyaltyAccountExpiringPointDeadline(this.points, this.expiresAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LoyaltyAccountExpiringPointDeadline build();
    }

    public static interface ExpiresAtStage {
        public _FinalStage expiresAt(@NotNull String var1);
    }

    public static interface PointsStage {
        public ExpiresAtStage points(int var1);

        public Builder from(LoyaltyAccountExpiringPointDeadline var1);
    }
}

