/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Merchant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListMerchantsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<Merchant>> merchant;
    private final Optional<Integer> cursor;
    private final Map<String, Object> additionalProperties;

    private ListMerchantsResponse(Optional<List<Error>> errors, Optional<List<Merchant>> merchant, Optional<Integer> cursor, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.merchant = merchant;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="merchant")
    public Optional<List<Merchant>> getMerchant() {
        return this.merchant;
    }

    @JsonProperty(value="cursor")
    public Optional<Integer> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListMerchantsResponse && this.equalTo((ListMerchantsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListMerchantsResponse other) {
        return this.errors.equals(other.errors) && this.merchant.equals(other.merchant) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.merchant, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<Merchant>> merchant = Optional.empty();
        private Optional<Integer> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListMerchantsResponse other) {
            this.errors(other.getErrors());
            this.merchant(other.getMerchant());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="merchant", nulls=Nulls.SKIP)
        public Builder merchant(Optional<List<Merchant>> merchant) {
            this.merchant = merchant;
            return this;
        }

        public Builder merchant(List<Merchant> merchant) {
            this.merchant = Optional.ofNullable(merchant);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<Integer> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(Integer cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public ListMerchantsResponse build() {
            return new ListMerchantsResponse(this.errors, this.merchant, this.cursor, this.additionalProperties);
        }
    }
}

