/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.LoyaltyProgram;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListLoyaltyProgramsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<LoyaltyProgram>> programs;
    private final Map<String, Object> additionalProperties;

    private ListLoyaltyProgramsResponse(Optional<List<Error>> errors, Optional<List<LoyaltyProgram>> programs, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.programs = programs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="programs")
    public Optional<List<LoyaltyProgram>> getPrograms() {
        return this.programs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListLoyaltyProgramsResponse && this.equalTo((ListLoyaltyProgramsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListLoyaltyProgramsResponse other) {
        return this.errors.equals(other.errors) && this.programs.equals(other.programs);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.programs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<LoyaltyProgram>> programs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListLoyaltyProgramsResponse other) {
            this.errors(other.getErrors());
            this.programs(other.getPrograms());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="programs", nulls=Nulls.SKIP)
        public Builder programs(Optional<List<LoyaltyProgram>> programs) {
            this.programs = programs;
            return this;
        }

        public Builder programs(List<LoyaltyProgram> programs) {
            this.programs = Optional.ofNullable(programs);
            return this;
        }

        public ListLoyaltyProgramsResponse build() {
            return new ListLoyaltyProgramsResponse(this.errors, this.programs, this.additionalProperties);
        }
    }
}

