/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Location;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListLocationsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<Location>> locations;
    private final Map<String, Object> additionalProperties;

    private ListLocationsResponse(Optional<List<Error>> errors, Optional<List<Location>> locations, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.locations = locations;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="locations")
    public Optional<List<Location>> getLocations() {
        return this.locations;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListLocationsResponse && this.equalTo((ListLocationsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListLocationsResponse other) {
        return this.errors.equals(other.errors) && this.locations.equals(other.locations);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.locations);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<Location>> locations = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListLocationsResponse other) {
            this.errors(other.getErrors());
            this.locations(other.getLocations());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="locations", nulls=Nulls.SKIP)
        public Builder locations(Optional<List<Location>> locations) {
            this.locations = locations;
            return this;
        }

        public Builder locations(List<Location> locations) {
            this.locations = Optional.ofNullable(locations);
            return this;
        }

        public ListLocationsResponse build() {
            return new ListLocationsResponse(this.errors, this.locations, this.additionalProperties);
        }
    }
}

