/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEntriesPayoutsRequest {
    private final String payoutId;
    private final Optional<SortOrder> sortOrder;
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private ListEntriesPayoutsRequest(String payoutId, Optional<SortOrder> sortOrder, Optional<String> cursor, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.payoutId = payoutId;
        this.sortOrder = sortOrder;
        this.cursor = cursor;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payout_id")
    public String getPayoutId() {
        return this.payoutId;
    }

    @JsonIgnore
    public Optional<SortOrder> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<SortOrder> _getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEntriesPayoutsRequest && this.equalTo((ListEntriesPayoutsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEntriesPayoutsRequest other) {
        return this.payoutId.equals(other.payoutId) && this.sortOrder.equals(other.sortOrder) && this.cursor.equals(other.cursor) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.payoutId, this.sortOrder, this.cursor, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PayoutIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PayoutIdStage,
    _FinalStage {
        private String payoutId;
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<SortOrder> sortOrder = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListEntriesPayoutsRequest other) {
            this.payoutId(other.getPayoutId());
            this.sortOrder(other.getSortOrder());
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            return this;
        }

        @Override
        @JsonSetter(value="payout_id")
        public _FinalStage payoutId(@NotNull String payoutId) {
            this.payoutId = Objects.requireNonNull(payoutId, "payoutId must not be null");
            return this;
        }

        @Override
        public _FinalStage limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @Override
        public _FinalStage cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @Override
        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public _FinalStage cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public _FinalStage sortOrder(Nullable<SortOrder> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        @Override
        public _FinalStage sortOrder(SortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @Override
        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public _FinalStage sortOrder(Optional<SortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public ListEntriesPayoutsRequest build() {
            return new ListEntriesPayoutsRequest(this.payoutId, this.sortOrder, this.cursor, this.limit, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListEntriesPayoutsRequest build();

        public _FinalStage sortOrder(Optional<SortOrder> var1);

        public _FinalStage sortOrder(SortOrder var1);

        public _FinalStage sortOrder(Nullable<SortOrder> var1);

        public _FinalStage cursor(Optional<String> var1);

        public _FinalStage cursor(String var1);

        public _FinalStage cursor(Nullable<String> var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage limit(Nullable<Integer> var1);
    }

    public static interface PayoutIdStage {
        public _FinalStage payoutId(@NotNull String var1);

        public Builder from(ListEntriesPayoutsRequest var1);
    }
}

