/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.EmployeeWage;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEmployeeWagesResponse {
    private final Optional<List<EmployeeWage>> employeeWages;
    private final Optional<String> cursor;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private ListEmployeeWagesResponse(Optional<List<EmployeeWage>> employeeWages, Optional<String> cursor, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.employeeWages = employeeWages;
        this.cursor = cursor;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="employee_wages")
    public Optional<List<EmployeeWage>> getEmployeeWages() {
        return this.employeeWages;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEmployeeWagesResponse && this.equalTo((ListEmployeeWagesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEmployeeWagesResponse other) {
        return this.employeeWages.equals(other.employeeWages) && this.cursor.equals(other.cursor) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.employeeWages, this.cursor, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<EmployeeWage>> employeeWages = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListEmployeeWagesResponse other) {
            this.employeeWages(other.getEmployeeWages());
            this.cursor(other.getCursor());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="employee_wages", nulls=Nulls.SKIP)
        public Builder employeeWages(Optional<List<EmployeeWage>> employeeWages) {
            this.employeeWages = employeeWages;
            return this;
        }

        public Builder employeeWages(List<EmployeeWage> employeeWages) {
            this.employeeWages = Optional.ofNullable(employeeWages);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public ListEmployeeWagesResponse build() {
            return new ListEmployeeWagesResponse(this.employeeWages, this.cursor, this.errors, this.additionalProperties);
        }
    }
}

