/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListBookingsRequest {
    private final Optional<Integer> limit;
    private final Optional<String> cursor;
    private final Optional<String> customerId;
    private final Optional<String> teamMemberId;
    private final Optional<String> locationId;
    private final Optional<String> startAtMin;
    private final Optional<String> startAtMax;
    private final Map<String, Object> additionalProperties;

    private ListBookingsRequest(Optional<Integer> limit, Optional<String> cursor, Optional<String> customerId, Optional<String> teamMemberId, Optional<String> locationId, Optional<String> startAtMin, Optional<String> startAtMax, Map<String, Object> additionalProperties) {
        this.limit = limit;
        this.cursor = cursor;
        this.customerId = customerId;
        this.teamMemberId = teamMemberId;
        this.locationId = locationId;
        this.startAtMin = startAtMin;
        this.startAtMax = startAtMax;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getStartAtMin() {
        if (this.startAtMin == null) {
            return Optional.empty();
        }
        return this.startAtMin;
    }

    @JsonIgnore
    public Optional<String> getStartAtMax() {
        if (this.startAtMax == null) {
            return Optional.empty();
        }
        return this.startAtMax;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="start_at_min")
    private Optional<String> _getStartAtMin() {
        return this.startAtMin;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="start_at_max")
    private Optional<String> _getStartAtMax() {
        return this.startAtMax;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListBookingsRequest && this.equalTo((ListBookingsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListBookingsRequest other) {
        return this.limit.equals(other.limit) && this.cursor.equals(other.cursor) && this.customerId.equals(other.customerId) && this.teamMemberId.equals(other.teamMemberId) && this.locationId.equals(other.locationId) && this.startAtMin.equals(other.startAtMin) && this.startAtMax.equals(other.startAtMax);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.cursor, this.customerId, this.teamMemberId, this.locationId, this.startAtMin, this.startAtMax);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> startAtMin = Optional.empty();
        private Optional<String> startAtMax = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListBookingsRequest other) {
            this.limit(other.getLimit());
            this.cursor(other.getCursor());
            this.customerId(other.getCustomerId());
            this.teamMemberId(other.getTeamMemberId());
            this.locationId(other.getLocationId());
            this.startAtMin(other.getStartAtMin());
            this.startAtMax(other.getStartAtMax());
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        public Builder customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        public Builder teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="start_at_min", nulls=Nulls.SKIP)
        public Builder startAtMin(Optional<String> startAtMin) {
            this.startAtMin = startAtMin;
            return this;
        }

        public Builder startAtMin(String startAtMin) {
            this.startAtMin = Optional.ofNullable(startAtMin);
            return this;
        }

        public Builder startAtMin(Nullable<String> startAtMin) {
            this.startAtMin = startAtMin.isNull() ? null : (startAtMin.isEmpty() ? Optional.empty() : Optional.of(startAtMin.get()));
            return this;
        }

        @JsonSetter(value="start_at_max", nulls=Nulls.SKIP)
        public Builder startAtMax(Optional<String> startAtMax) {
            this.startAtMax = startAtMax;
            return this;
        }

        public Builder startAtMax(String startAtMax) {
            this.startAtMax = Optional.ofNullable(startAtMax);
            return this;
        }

        public Builder startAtMax(Nullable<String> startAtMax) {
            this.startAtMax = startAtMax.isNull() ? null : (startAtMax.isEmpty() ? Optional.empty() : Optional.of(startAtMax.get()));
            return this;
        }

        public ListBookingsRequest build() {
            return new ListBookingsRequest(this.limit, this.cursor, this.customerId, this.teamMemberId, this.locationId, this.startAtMin, this.startAtMax, this.additionalProperties);
        }
    }
}

