/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BankAccount;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListBankAccountsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<BankAccount>> bankAccounts;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private ListBankAccountsResponse(Optional<List<Error>> errors, Optional<List<BankAccount>> bankAccounts, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.bankAccounts = bankAccounts;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="bank_accounts")
    public Optional<List<BankAccount>> getBankAccounts() {
        return this.bankAccounts;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListBankAccountsResponse && this.equalTo((ListBankAccountsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListBankAccountsResponse other) {
        return this.errors.equals(other.errors) && this.bankAccounts.equals(other.bankAccounts) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.bankAccounts, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<BankAccount>> bankAccounts = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListBankAccountsResponse other) {
            this.errors(other.getErrors());
            this.bankAccounts(other.getBankAccounts());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="bank_accounts", nulls=Nulls.SKIP)
        public Builder bankAccounts(Optional<List<BankAccount>> bankAccounts) {
            this.bankAccounts = bankAccounts;
            return this;
        }

        public Builder bankAccounts(List<BankAccount> bankAccounts) {
            this.bankAccounts = Optional.ofNullable(bankAccounts);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public ListBankAccountsResponse build() {
            return new ListBankAccountsResponse(this.errors, this.bankAccounts, this.cursor, this.additionalProperties);
        }
    }
}

