/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogPricingType;
import com.squareup.square.types.InventoryAlertType;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ItemVariationLocationOverrides {
    private final Optional<String> locationId;
    private final Optional<Money> priceMoney;
    private final Optional<CatalogPricingType> pricingType;
    private final Optional<Boolean> trackInventory;
    private final Optional<InventoryAlertType> inventoryAlertType;
    private final Optional<Long> inventoryAlertThreshold;
    private final Optional<Boolean> soldOut;
    private final Optional<String> soldOutValidUntil;
    private final Map<String, Object> additionalProperties;

    private ItemVariationLocationOverrides(Optional<String> locationId, Optional<Money> priceMoney, Optional<CatalogPricingType> pricingType, Optional<Boolean> trackInventory, Optional<InventoryAlertType> inventoryAlertType, Optional<Long> inventoryAlertThreshold, Optional<Boolean> soldOut, Optional<String> soldOutValidUntil, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.priceMoney = priceMoney;
        this.pricingType = pricingType;
        this.trackInventory = trackInventory;
        this.inventoryAlertType = inventoryAlertType;
        this.inventoryAlertThreshold = inventoryAlertThreshold;
        this.soldOut = soldOut;
        this.soldOutValidUntil = soldOutValidUntil;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonProperty(value="price_money")
    public Optional<Money> getPriceMoney() {
        return this.priceMoney;
    }

    @JsonProperty(value="pricing_type")
    public Optional<CatalogPricingType> getPricingType() {
        return this.pricingType;
    }

    @JsonIgnore
    public Optional<Boolean> getTrackInventory() {
        if (this.trackInventory == null) {
            return Optional.empty();
        }
        return this.trackInventory;
    }

    @JsonProperty(value="inventory_alert_type")
    public Optional<InventoryAlertType> getInventoryAlertType() {
        return this.inventoryAlertType;
    }

    @JsonIgnore
    public Optional<Long> getInventoryAlertThreshold() {
        if (this.inventoryAlertThreshold == null) {
            return Optional.empty();
        }
        return this.inventoryAlertThreshold;
    }

    @JsonProperty(value="sold_out")
    public Optional<Boolean> getSoldOut() {
        return this.soldOut;
    }

    @JsonProperty(value="sold_out_valid_until")
    public Optional<String> getSoldOutValidUntil() {
        return this.soldOutValidUntil;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="track_inventory")
    private Optional<Boolean> _getTrackInventory() {
        return this.trackInventory;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="inventory_alert_threshold")
    private Optional<Long> _getInventoryAlertThreshold() {
        return this.inventoryAlertThreshold;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ItemVariationLocationOverrides && this.equalTo((ItemVariationLocationOverrides)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ItemVariationLocationOverrides other) {
        return this.locationId.equals(other.locationId) && this.priceMoney.equals(other.priceMoney) && this.pricingType.equals(other.pricingType) && this.trackInventory.equals(other.trackInventory) && this.inventoryAlertType.equals(other.inventoryAlertType) && this.inventoryAlertThreshold.equals(other.inventoryAlertThreshold) && this.soldOut.equals(other.soldOut) && this.soldOutValidUntil.equals(other.soldOutValidUntil);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.priceMoney, this.pricingType, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.soldOut, this.soldOutValidUntil);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> locationId = Optional.empty();
        private Optional<Money> priceMoney = Optional.empty();
        private Optional<CatalogPricingType> pricingType = Optional.empty();
        private Optional<Boolean> trackInventory = Optional.empty();
        private Optional<InventoryAlertType> inventoryAlertType = Optional.empty();
        private Optional<Long> inventoryAlertThreshold = Optional.empty();
        private Optional<Boolean> soldOut = Optional.empty();
        private Optional<String> soldOutValidUntil = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ItemVariationLocationOverrides other) {
            this.locationId(other.getLocationId());
            this.priceMoney(other.getPriceMoney());
            this.pricingType(other.getPricingType());
            this.trackInventory(other.getTrackInventory());
            this.inventoryAlertType(other.getInventoryAlertType());
            this.inventoryAlertThreshold(other.getInventoryAlertThreshold());
            this.soldOut(other.getSoldOut());
            this.soldOutValidUntil(other.getSoldOutValidUntil());
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="price_money", nulls=Nulls.SKIP)
        public Builder priceMoney(Optional<Money> priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = Optional.ofNullable(priceMoney);
            return this;
        }

        @JsonSetter(value="pricing_type", nulls=Nulls.SKIP)
        public Builder pricingType(Optional<CatalogPricingType> pricingType) {
            this.pricingType = pricingType;
            return this;
        }

        public Builder pricingType(CatalogPricingType pricingType) {
            this.pricingType = Optional.ofNullable(pricingType);
            return this;
        }

        @JsonSetter(value="track_inventory", nulls=Nulls.SKIP)
        public Builder trackInventory(Optional<Boolean> trackInventory) {
            this.trackInventory = trackInventory;
            return this;
        }

        public Builder trackInventory(Boolean trackInventory) {
            this.trackInventory = Optional.ofNullable(trackInventory);
            return this;
        }

        public Builder trackInventory(Nullable<Boolean> trackInventory) {
            this.trackInventory = trackInventory.isNull() ? null : (trackInventory.isEmpty() ? Optional.empty() : Optional.of(trackInventory.get()));
            return this;
        }

        @JsonSetter(value="inventory_alert_type", nulls=Nulls.SKIP)
        public Builder inventoryAlertType(Optional<InventoryAlertType> inventoryAlertType) {
            this.inventoryAlertType = inventoryAlertType;
            return this;
        }

        public Builder inventoryAlertType(InventoryAlertType inventoryAlertType) {
            this.inventoryAlertType = Optional.ofNullable(inventoryAlertType);
            return this;
        }

        @JsonSetter(value="inventory_alert_threshold", nulls=Nulls.SKIP)
        public Builder inventoryAlertThreshold(Optional<Long> inventoryAlertThreshold) {
            this.inventoryAlertThreshold = inventoryAlertThreshold;
            return this;
        }

        public Builder inventoryAlertThreshold(Long inventoryAlertThreshold) {
            this.inventoryAlertThreshold = Optional.ofNullable(inventoryAlertThreshold);
            return this;
        }

        public Builder inventoryAlertThreshold(Nullable<Long> inventoryAlertThreshold) {
            this.inventoryAlertThreshold = inventoryAlertThreshold.isNull() ? null : (inventoryAlertThreshold.isEmpty() ? Optional.empty() : Optional.of(inventoryAlertThreshold.get()));
            return this;
        }

        @JsonSetter(value="sold_out", nulls=Nulls.SKIP)
        public Builder soldOut(Optional<Boolean> soldOut) {
            this.soldOut = soldOut;
            return this;
        }

        public Builder soldOut(Boolean soldOut) {
            this.soldOut = Optional.ofNullable(soldOut);
            return this;
        }

        @JsonSetter(value="sold_out_valid_until", nulls=Nulls.SKIP)
        public Builder soldOutValidUntil(Optional<String> soldOutValidUntil) {
            this.soldOutValidUntil = soldOutValidUntil;
            return this;
        }

        public Builder soldOutValidUntil(String soldOutValidUntil) {
            this.soldOutValidUntil = Optional.ofNullable(soldOutValidUntil);
            return this;
        }

        public ItemVariationLocationOverrides build() {
            return new ItemVariationLocationOverrides(this.locationId, this.priceMoney, this.pricingType, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.soldOut, this.soldOutValidUntil, this.additionalProperties);
        }
    }
}

