/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class InvoiceStatus {
    public static final InvoiceStatus PARTIALLY_PAID = new InvoiceStatus(Value.PARTIALLY_PAID, "PARTIALLY_PAID");
    public static final InvoiceStatus PARTIALLY_REFUNDED = new InvoiceStatus(Value.PARTIALLY_REFUNDED, "PARTIALLY_REFUNDED");
    public static final InvoiceStatus CANCELED = new InvoiceStatus(Value.CANCELED, "CANCELED");
    public static final InvoiceStatus PAYMENT_PENDING = new InvoiceStatus(Value.PAYMENT_PENDING, "PAYMENT_PENDING");
    public static final InvoiceStatus SCHEDULED = new InvoiceStatus(Value.SCHEDULED, "SCHEDULED");
    public static final InvoiceStatus REFUNDED = new InvoiceStatus(Value.REFUNDED, "REFUNDED");
    public static final InvoiceStatus DRAFT = new InvoiceStatus(Value.DRAFT, "DRAFT");
    public static final InvoiceStatus PAID = new InvoiceStatus(Value.PAID, "PAID");
    public static final InvoiceStatus UNPAID = new InvoiceStatus(Value.UNPAID, "UNPAID");
    public static final InvoiceStatus FAILED = new InvoiceStatus(Value.FAILED, "FAILED");
    private final Value value;
    private final String string;

    InvoiceStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof InvoiceStatus && this.string.equals(((InvoiceStatus)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case PARTIALLY_PAID: {
                return visitor.visitPartiallyPaid();
            }
            case PARTIALLY_REFUNDED: {
                return visitor.visitPartiallyRefunded();
            }
            case CANCELED: {
                return visitor.visitCanceled();
            }
            case PAYMENT_PENDING: {
                return visitor.visitPaymentPending();
            }
            case SCHEDULED: {
                return visitor.visitScheduled();
            }
            case REFUNDED: {
                return visitor.visitRefunded();
            }
            case DRAFT: {
                return visitor.visitDraft();
            }
            case PAID: {
                return visitor.visitPaid();
            }
            case UNPAID: {
                return visitor.visitUnpaid();
            }
            case FAILED: {
                return visitor.visitFailed();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static InvoiceStatus valueOf(String value) {
        switch (value) {
            case "PARTIALLY_PAID": {
                return PARTIALLY_PAID;
            }
            case "PARTIALLY_REFUNDED": {
                return PARTIALLY_REFUNDED;
            }
            case "CANCELED": {
                return CANCELED;
            }
            case "PAYMENT_PENDING": {
                return PAYMENT_PENDING;
            }
            case "SCHEDULED": {
                return SCHEDULED;
            }
            case "REFUNDED": {
                return REFUNDED;
            }
            case "DRAFT": {
                return DRAFT;
            }
            case "PAID": {
                return PAID;
            }
            case "UNPAID": {
                return UNPAID;
            }
            case "FAILED": {
                return FAILED;
            }
        }
        return new InvoiceStatus(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitDraft();

        public T visitUnpaid();

        public T visitScheduled();

        public T visitPartiallyPaid();

        public T visitPaid();

        public T visitPartiallyRefunded();

        public T visitRefunded();

        public T visitCanceled();

        public T visitFailed();

        public T visitPaymentPending();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        DRAFT,
        UNPAID,
        SCHEDULED,
        PARTIALLY_PAID,
        PAID,
        PARTIALLY_REFUNDED,
        REFUNDED,
        CANCELED,
        FAILED,
        PAYMENT_PENDING,
        UNKNOWN;

    }
}

