/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.InvoiceRecipientTaxIds;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceRecipient {
    private final Optional<String> customerId;
    private final Optional<String> givenName;
    private final Optional<String> familyName;
    private final Optional<String> emailAddress;
    private final Optional<Address> address;
    private final Optional<String> phoneNumber;
    private final Optional<String> companyName;
    private final Optional<InvoiceRecipientTaxIds> taxIds;
    private final Map<String, Object> additionalProperties;

    private InvoiceRecipient(Optional<String> customerId, Optional<String> givenName, Optional<String> familyName, Optional<String> emailAddress, Optional<Address> address, Optional<String> phoneNumber, Optional<String> companyName, Optional<InvoiceRecipientTaxIds> taxIds, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.givenName = givenName;
        this.familyName = familyName;
        this.emailAddress = emailAddress;
        this.address = address;
        this.phoneNumber = phoneNumber;
        this.companyName = companyName;
        this.taxIds = taxIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonProperty(value="given_name")
    public Optional<String> getGivenName() {
        return this.givenName;
    }

    @JsonProperty(value="family_name")
    public Optional<String> getFamilyName() {
        return this.familyName;
    }

    @JsonProperty(value="email_address")
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="address")
    public Optional<Address> getAddress() {
        return this.address;
    }

    @JsonProperty(value="phone_number")
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="company_name")
    public Optional<String> getCompanyName() {
        return this.companyName;
    }

    @JsonProperty(value="tax_ids")
    public Optional<InvoiceRecipientTaxIds> getTaxIds() {
        return this.taxIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceRecipient && this.equalTo((InvoiceRecipient)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceRecipient other) {
        return this.customerId.equals(other.customerId) && this.givenName.equals(other.givenName) && this.familyName.equals(other.familyName) && this.emailAddress.equals(other.emailAddress) && this.address.equals(other.address) && this.phoneNumber.equals(other.phoneNumber) && this.companyName.equals(other.companyName) && this.taxIds.equals(other.taxIds);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.givenName, this.familyName, this.emailAddress, this.address, this.phoneNumber, this.companyName, this.taxIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> customerId = Optional.empty();
        private Optional<String> givenName = Optional.empty();
        private Optional<String> familyName = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<Address> address = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> companyName = Optional.empty();
        private Optional<InvoiceRecipientTaxIds> taxIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoiceRecipient other) {
            this.customerId(other.getCustomerId());
            this.givenName(other.getGivenName());
            this.familyName(other.getFamilyName());
            this.emailAddress(other.getEmailAddress());
            this.address(other.getAddress());
            this.phoneNumber(other.getPhoneNumber());
            this.companyName(other.getCompanyName());
            this.taxIds(other.getTaxIds());
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        public Builder customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @JsonSetter(value="given_name", nulls=Nulls.SKIP)
        public Builder givenName(Optional<String> givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = Optional.ofNullable(givenName);
            return this;
        }

        @JsonSetter(value="family_name", nulls=Nulls.SKIP)
        public Builder familyName(Optional<String> familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = Optional.ofNullable(familyName);
            return this;
        }

        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public Builder emailAddress(Optional<String> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        @JsonSetter(value="address", nulls=Nulls.SKIP)
        public Builder address(Optional<Address> address) {
            this.address = address;
            return this;
        }

        public Builder address(Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        @JsonSetter(value="company_name", nulls=Nulls.SKIP)
        public Builder companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        @JsonSetter(value="tax_ids", nulls=Nulls.SKIP)
        public Builder taxIds(Optional<InvoiceRecipientTaxIds> taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public Builder taxIds(InvoiceRecipientTaxIds taxIds) {
            this.taxIds = Optional.ofNullable(taxIds);
            return this;
        }

        public InvoiceRecipient build() {
            return new InvoiceRecipient(this.customerId, this.givenName, this.familyName, this.emailAddress, this.address, this.phoneNumber, this.companyName, this.taxIds, this.additionalProperties);
        }
    }
}

