/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceFilter {
    private final List<String> locationIds;
    private final Optional<List<String>> customerIds;
    private final Map<String, Object> additionalProperties;

    private InvoiceFilter(List<String> locationIds, Optional<List<String>> customerIds, Map<String, Object> additionalProperties) {
        this.locationIds = locationIds;
        this.customerIds = customerIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_ids")
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonIgnore
    public Optional<List<String>> getCustomerIds() {
        if (this.customerIds == null) {
            return Optional.empty();
        }
        return this.customerIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_ids")
    private Optional<List<String>> _getCustomerIds() {
        return this.customerIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceFilter && this.equalTo((InvoiceFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceFilter other) {
        return this.locationIds.equals(other.locationIds) && this.customerIds.equals(other.customerIds);
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.customerIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> locationIds = new ArrayList<String>();
        private Optional<List<String>> customerIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoiceFilter other) {
            this.locationIds(other.getLocationIds());
            this.customerIds(other.getCustomerIds());
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(List<String> locationIds) {
            this.locationIds.clear();
            this.locationIds.addAll(locationIds);
            return this;
        }

        public Builder addLocationIds(String locationIds) {
            this.locationIds.add(locationIds);
            return this;
        }

        public Builder addAllLocationIds(List<String> locationIds) {
            this.locationIds.addAll(locationIds);
            return this;
        }

        @JsonSetter(value="customer_ids", nulls=Nulls.SKIP)
        public Builder customerIds(Optional<List<String>> customerIds) {
            this.customerIds = customerIds;
            return this;
        }

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = Optional.ofNullable(customerIds);
            return this;
        }

        public Builder customerIds(Nullable<List<String>> customerIds) {
            this.customerIds = customerIds.isNull() ? null : (customerIds.isEmpty() ? Optional.empty() : Optional.of(customerIds.get()));
            return this;
        }

        public InvoiceFilter build() {
            return new InvoiceFilter(this.locationIds, this.customerIds, this.additionalProperties);
        }
    }
}

