/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceAttachment {
    private final Optional<String> id;
    private final Optional<String> filename;
    private final Optional<String> description;
    private final Optional<Integer> filesize;
    private final Optional<String> hash;
    private final Optional<String> mimeType;
    private final Optional<String> uploadedAt;
    private final Map<String, Object> additionalProperties;

    private InvoiceAttachment(Optional<String> id, Optional<String> filename, Optional<String> description, Optional<Integer> filesize, Optional<String> hash, Optional<String> mimeType, Optional<String> uploadedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.filename = filename;
        this.description = description;
        this.filesize = filesize;
        this.hash = hash;
        this.mimeType = mimeType;
        this.uploadedAt = uploadedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="filename")
    public Optional<String> getFilename() {
        return this.filename;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="filesize")
    public Optional<Integer> getFilesize() {
        return this.filesize;
    }

    @JsonProperty(value="hash")
    public Optional<String> getHash() {
        return this.hash;
    }

    @JsonProperty(value="mime_type")
    public Optional<String> getMimeType() {
        return this.mimeType;
    }

    @JsonProperty(value="uploaded_at")
    public Optional<String> getUploadedAt() {
        return this.uploadedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceAttachment && this.equalTo((InvoiceAttachment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceAttachment other) {
        return this.id.equals(other.id) && this.filename.equals(other.filename) && this.description.equals(other.description) && this.filesize.equals(other.filesize) && this.hash.equals(other.hash) && this.mimeType.equals(other.mimeType) && this.uploadedAt.equals(other.uploadedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.filename, this.description, this.filesize, this.hash, this.mimeType, this.uploadedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> filename = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Integer> filesize = Optional.empty();
        private Optional<String> hash = Optional.empty();
        private Optional<String> mimeType = Optional.empty();
        private Optional<String> uploadedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoiceAttachment other) {
            this.id(other.getId());
            this.filename(other.getFilename());
            this.description(other.getDescription());
            this.filesize(other.getFilesize());
            this.hash(other.getHash());
            this.mimeType(other.getMimeType());
            this.uploadedAt(other.getUploadedAt());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="filename", nulls=Nulls.SKIP)
        public Builder filename(Optional<String> filename) {
            this.filename = filename;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = Optional.ofNullable(filename);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="filesize", nulls=Nulls.SKIP)
        public Builder filesize(Optional<Integer> filesize) {
            this.filesize = filesize;
            return this;
        }

        public Builder filesize(Integer filesize) {
            this.filesize = Optional.ofNullable(filesize);
            return this;
        }

        @JsonSetter(value="hash", nulls=Nulls.SKIP)
        public Builder hash(Optional<String> hash) {
            this.hash = hash;
            return this;
        }

        public Builder hash(String hash) {
            this.hash = Optional.ofNullable(hash);
            return this;
        }

        @JsonSetter(value="mime_type", nulls=Nulls.SKIP)
        public Builder mimeType(Optional<String> mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = Optional.ofNullable(mimeType);
            return this;
        }

        @JsonSetter(value="uploaded_at", nulls=Nulls.SKIP)
        public Builder uploadedAt(Optional<String> uploadedAt) {
            this.uploadedAt = uploadedAt;
            return this;
        }

        public Builder uploadedAt(String uploadedAt) {
            this.uploadedAt = Optional.ofNullable(uploadedAt);
            return this;
        }

        public InvoiceAttachment build() {
            return new InvoiceAttachment(this.id, this.filename, this.description, this.filesize, this.hash, this.mimeType, this.uploadedAt, this.additionalProperties);
        }
    }
}

