/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InvoiceAcceptedPaymentMethods {
    private final Optional<Boolean> card;
    private final Optional<Boolean> squareGiftCard;
    private final Optional<Boolean> bankAccount;
    private final Optional<Boolean> buyNowPayLater;
    private final Optional<Boolean> cashAppPay;
    private final Map<String, Object> additionalProperties;

    private InvoiceAcceptedPaymentMethods(Optional<Boolean> card, Optional<Boolean> squareGiftCard, Optional<Boolean> bankAccount, Optional<Boolean> buyNowPayLater, Optional<Boolean> cashAppPay, Map<String, Object> additionalProperties) {
        this.card = card;
        this.squareGiftCard = squareGiftCard;
        this.bankAccount = bankAccount;
        this.buyNowPayLater = buyNowPayLater;
        this.cashAppPay = cashAppPay;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Boolean> getCard() {
        if (this.card == null) {
            return Optional.empty();
        }
        return this.card;
    }

    @JsonIgnore
    public Optional<Boolean> getSquareGiftCard() {
        if (this.squareGiftCard == null) {
            return Optional.empty();
        }
        return this.squareGiftCard;
    }

    @JsonIgnore
    public Optional<Boolean> getBankAccount() {
        if (this.bankAccount == null) {
            return Optional.empty();
        }
        return this.bankAccount;
    }

    @JsonIgnore
    public Optional<Boolean> getBuyNowPayLater() {
        if (this.buyNowPayLater == null) {
            return Optional.empty();
        }
        return this.buyNowPayLater;
    }

    @JsonIgnore
    public Optional<Boolean> getCashAppPay() {
        if (this.cashAppPay == null) {
            return Optional.empty();
        }
        return this.cashAppPay;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="card")
    private Optional<Boolean> _getCard() {
        return this.card;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="square_gift_card")
    private Optional<Boolean> _getSquareGiftCard() {
        return this.squareGiftCard;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="bank_account")
    private Optional<Boolean> _getBankAccount() {
        return this.bankAccount;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="buy_now_pay_later")
    private Optional<Boolean> _getBuyNowPayLater() {
        return this.buyNowPayLater;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cash_app_pay")
    private Optional<Boolean> _getCashAppPay() {
        return this.cashAppPay;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InvoiceAcceptedPaymentMethods && this.equalTo((InvoiceAcceptedPaymentMethods)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InvoiceAcceptedPaymentMethods other) {
        return this.card.equals(other.card) && this.squareGiftCard.equals(other.squareGiftCard) && this.bankAccount.equals(other.bankAccount) && this.buyNowPayLater.equals(other.buyNowPayLater) && this.cashAppPay.equals(other.cashAppPay);
    }

    public int hashCode() {
        return Objects.hash(this.card, this.squareGiftCard, this.bankAccount, this.buyNowPayLater, this.cashAppPay);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> card = Optional.empty();
        private Optional<Boolean> squareGiftCard = Optional.empty();
        private Optional<Boolean> bankAccount = Optional.empty();
        private Optional<Boolean> buyNowPayLater = Optional.empty();
        private Optional<Boolean> cashAppPay = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InvoiceAcceptedPaymentMethods other) {
            this.card(other.getCard());
            this.squareGiftCard(other.getSquareGiftCard());
            this.bankAccount(other.getBankAccount());
            this.buyNowPayLater(other.getBuyNowPayLater());
            this.cashAppPay(other.getCashAppPay());
            return this;
        }

        @JsonSetter(value="card", nulls=Nulls.SKIP)
        public Builder card(Optional<Boolean> card) {
            this.card = card;
            return this;
        }

        public Builder card(Boolean card) {
            this.card = Optional.ofNullable(card);
            return this;
        }

        public Builder card(Nullable<Boolean> card) {
            this.card = card.isNull() ? null : (card.isEmpty() ? Optional.empty() : Optional.of(card.get()));
            return this;
        }

        @JsonSetter(value="square_gift_card", nulls=Nulls.SKIP)
        public Builder squareGiftCard(Optional<Boolean> squareGiftCard) {
            this.squareGiftCard = squareGiftCard;
            return this;
        }

        public Builder squareGiftCard(Boolean squareGiftCard) {
            this.squareGiftCard = Optional.ofNullable(squareGiftCard);
            return this;
        }

        public Builder squareGiftCard(Nullable<Boolean> squareGiftCard) {
            this.squareGiftCard = squareGiftCard.isNull() ? null : (squareGiftCard.isEmpty() ? Optional.empty() : Optional.of(squareGiftCard.get()));
            return this;
        }

        @JsonSetter(value="bank_account", nulls=Nulls.SKIP)
        public Builder bankAccount(Optional<Boolean> bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public Builder bankAccount(Boolean bankAccount) {
            this.bankAccount = Optional.ofNullable(bankAccount);
            return this;
        }

        public Builder bankAccount(Nullable<Boolean> bankAccount) {
            this.bankAccount = bankAccount.isNull() ? null : (bankAccount.isEmpty() ? Optional.empty() : Optional.of(bankAccount.get()));
            return this;
        }

        @JsonSetter(value="buy_now_pay_later", nulls=Nulls.SKIP)
        public Builder buyNowPayLater(Optional<Boolean> buyNowPayLater) {
            this.buyNowPayLater = buyNowPayLater;
            return this;
        }

        public Builder buyNowPayLater(Boolean buyNowPayLater) {
            this.buyNowPayLater = Optional.ofNullable(buyNowPayLater);
            return this;
        }

        public Builder buyNowPayLater(Nullable<Boolean> buyNowPayLater) {
            this.buyNowPayLater = buyNowPayLater.isNull() ? null : (buyNowPayLater.isEmpty() ? Optional.empty() : Optional.of(buyNowPayLater.get()));
            return this;
        }

        @JsonSetter(value="cash_app_pay", nulls=Nulls.SKIP)
        public Builder cashAppPay(Optional<Boolean> cashAppPay) {
            this.cashAppPay = cashAppPay;
            return this;
        }

        public Builder cashAppPay(Boolean cashAppPay) {
            this.cashAppPay = Optional.ofNullable(cashAppPay);
            return this;
        }

        public Builder cashAppPay(Nullable<Boolean> cashAppPay) {
            this.cashAppPay = cashAppPay.isNull() ? null : (cashAppPay.isEmpty() ? Optional.empty() : Optional.of(cashAppPay.get()));
            return this;
        }

        public InvoiceAcceptedPaymentMethods build() {
            return new InvoiceAcceptedPaymentMethods(this.card, this.squareGiftCard, this.bankAccount, this.buyNowPayLater, this.cashAppPay, this.additionalProperties);
        }
    }
}

