/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InvoiceAcceptedPaymentMethods;
import com.squareup.square.types.InvoiceAttachment;
import com.squareup.square.types.InvoiceCustomField;
import com.squareup.square.types.InvoiceDeliveryMethod;
import com.squareup.square.types.InvoicePaymentRequest;
import com.squareup.square.types.InvoiceRecipient;
import com.squareup.square.types.InvoiceStatus;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Invoice {
    private final Optional<String> id;
    private final Optional<Integer> version;
    private final Optional<String> locationId;
    private final Optional<String> orderId;
    private final Optional<InvoiceRecipient> primaryRecipient;
    private final Optional<List<InvoicePaymentRequest>> paymentRequests;
    private final Optional<InvoiceDeliveryMethod> deliveryMethod;
    private final Optional<String> invoiceNumber;
    private final Optional<String> title;
    private final Optional<String> description;
    private final Optional<String> scheduledAt;
    private final Optional<String> publicUrl;
    private final Optional<Money> nextPaymentAmountMoney;
    private final Optional<InvoiceStatus> status;
    private final Optional<String> timezone;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<InvoiceAcceptedPaymentMethods> acceptedPaymentMethods;
    private final Optional<List<InvoiceCustomField>> customFields;
    private final Optional<String> subscriptionId;
    private final Optional<String> saleOrServiceDate;
    private final Optional<String> paymentConditions;
    private final Optional<Boolean> storePaymentMethodEnabled;
    private final Optional<List<InvoiceAttachment>> attachments;
    private final Optional<String> creatorTeamMemberId;
    private final Map<String, Object> additionalProperties;

    private Invoice(Optional<String> id, Optional<Integer> version, Optional<String> locationId, Optional<String> orderId, Optional<InvoiceRecipient> primaryRecipient, Optional<List<InvoicePaymentRequest>> paymentRequests, Optional<InvoiceDeliveryMethod> deliveryMethod, Optional<String> invoiceNumber, Optional<String> title, Optional<String> description, Optional<String> scheduledAt, Optional<String> publicUrl, Optional<Money> nextPaymentAmountMoney, Optional<InvoiceStatus> status, Optional<String> timezone, Optional<String> createdAt, Optional<String> updatedAt, Optional<InvoiceAcceptedPaymentMethods> acceptedPaymentMethods, Optional<List<InvoiceCustomField>> customFields, Optional<String> subscriptionId, Optional<String> saleOrServiceDate, Optional<String> paymentConditions, Optional<Boolean> storePaymentMethodEnabled, Optional<List<InvoiceAttachment>> attachments, Optional<String> creatorTeamMemberId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.version = version;
        this.locationId = locationId;
        this.orderId = orderId;
        this.primaryRecipient = primaryRecipient;
        this.paymentRequests = paymentRequests;
        this.deliveryMethod = deliveryMethod;
        this.invoiceNumber = invoiceNumber;
        this.title = title;
        this.description = description;
        this.scheduledAt = scheduledAt;
        this.publicUrl = publicUrl;
        this.nextPaymentAmountMoney = nextPaymentAmountMoney;
        this.status = status;
        this.timezone = timezone;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.acceptedPaymentMethods = acceptedPaymentMethods;
        this.customFields = customFields;
        this.subscriptionId = subscriptionId;
        this.saleOrServiceDate = saleOrServiceDate;
        this.paymentConditions = paymentConditions;
        this.storePaymentMethodEnabled = storePaymentMethodEnabled;
        this.attachments = attachments;
        this.creatorTeamMemberId = creatorTeamMemberId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getOrderId() {
        if (this.orderId == null) {
            return Optional.empty();
        }
        return this.orderId;
    }

    @JsonProperty(value="primary_recipient")
    public Optional<InvoiceRecipient> getPrimaryRecipient() {
        return this.primaryRecipient;
    }

    @JsonIgnore
    public Optional<List<InvoicePaymentRequest>> getPaymentRequests() {
        if (this.paymentRequests == null) {
            return Optional.empty();
        }
        return this.paymentRequests;
    }

    @JsonProperty(value="delivery_method")
    public Optional<InvoiceDeliveryMethod> getDeliveryMethod() {
        return this.deliveryMethod;
    }

    @JsonIgnore
    public Optional<String> getInvoiceNumber() {
        if (this.invoiceNumber == null) {
            return Optional.empty();
        }
        return this.invoiceNumber;
    }

    @JsonIgnore
    public Optional<String> getTitle() {
        if (this.title == null) {
            return Optional.empty();
        }
        return this.title;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonIgnore
    public Optional<String> getScheduledAt() {
        if (this.scheduledAt == null) {
            return Optional.empty();
        }
        return this.scheduledAt;
    }

    @JsonProperty(value="public_url")
    public Optional<String> getPublicUrl() {
        return this.publicUrl;
    }

    @JsonProperty(value="next_payment_amount_money")
    public Optional<Money> getNextPaymentAmountMoney() {
        return this.nextPaymentAmountMoney;
    }

    @JsonProperty(value="status")
    public Optional<InvoiceStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="timezone")
    public Optional<String> getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="accepted_payment_methods")
    public Optional<InvoiceAcceptedPaymentMethods> getAcceptedPaymentMethods() {
        return this.acceptedPaymentMethods;
    }

    @JsonIgnore
    public Optional<List<InvoiceCustomField>> getCustomFields() {
        if (this.customFields == null) {
            return Optional.empty();
        }
        return this.customFields;
    }

    @JsonProperty(value="subscription_id")
    public Optional<String> getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonIgnore
    public Optional<String> getSaleOrServiceDate() {
        if (this.saleOrServiceDate == null) {
            return Optional.empty();
        }
        return this.saleOrServiceDate;
    }

    @JsonIgnore
    public Optional<String> getPaymentConditions() {
        if (this.paymentConditions == null) {
            return Optional.empty();
        }
        return this.paymentConditions;
    }

    @JsonIgnore
    public Optional<Boolean> getStorePaymentMethodEnabled() {
        if (this.storePaymentMethodEnabled == null) {
            return Optional.empty();
        }
        return this.storePaymentMethodEnabled;
    }

    @JsonProperty(value="attachments")
    public Optional<List<InvoiceAttachment>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="creator_team_member_id")
    public Optional<String> getCreatorTeamMemberId() {
        return this.creatorTeamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_id")
    private Optional<String> _getOrderId() {
        return this.orderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_requests")
    private Optional<List<InvoicePaymentRequest>> _getPaymentRequests() {
        return this.paymentRequests;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="invoice_number")
    private Optional<String> _getInvoiceNumber() {
        return this.invoiceNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="title")
    private Optional<String> _getTitle() {
        return this.title;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="scheduled_at")
    private Optional<String> _getScheduledAt() {
        return this.scheduledAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="custom_fields")
    private Optional<List<InvoiceCustomField>> _getCustomFields() {
        return this.customFields;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sale_or_service_date")
    private Optional<String> _getSaleOrServiceDate() {
        return this.saleOrServiceDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_conditions")
    private Optional<String> _getPaymentConditions() {
        return this.paymentConditions;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="store_payment_method_enabled")
    private Optional<Boolean> _getStorePaymentMethodEnabled() {
        return this.storePaymentMethodEnabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Invoice && this.equalTo((Invoice)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Invoice other) {
        return this.id.equals(other.id) && this.version.equals(other.version) && this.locationId.equals(other.locationId) && this.orderId.equals(other.orderId) && this.primaryRecipient.equals(other.primaryRecipient) && this.paymentRequests.equals(other.paymentRequests) && this.deliveryMethod.equals(other.deliveryMethod) && this.invoiceNumber.equals(other.invoiceNumber) && this.title.equals(other.title) && this.description.equals(other.description) && this.scheduledAt.equals(other.scheduledAt) && this.publicUrl.equals(other.publicUrl) && this.nextPaymentAmountMoney.equals(other.nextPaymentAmountMoney) && this.status.equals(other.status) && this.timezone.equals(other.timezone) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.acceptedPaymentMethods.equals(other.acceptedPaymentMethods) && this.customFields.equals(other.customFields) && this.subscriptionId.equals(other.subscriptionId) && this.saleOrServiceDate.equals(other.saleOrServiceDate) && this.paymentConditions.equals(other.paymentConditions) && this.storePaymentMethodEnabled.equals(other.storePaymentMethodEnabled) && this.attachments.equals(other.attachments) && this.creatorTeamMemberId.equals(other.creatorTeamMemberId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.locationId, this.orderId, this.primaryRecipient, this.paymentRequests, this.deliveryMethod, this.invoiceNumber, this.title, this.description, this.scheduledAt, this.publicUrl, this.nextPaymentAmountMoney, this.status, this.timezone, this.createdAt, this.updatedAt, this.acceptedPaymentMethods, this.customFields, this.subscriptionId, this.saleOrServiceDate, this.paymentConditions, this.storePaymentMethodEnabled, this.attachments, this.creatorTeamMemberId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        private Optional<InvoiceRecipient> primaryRecipient = Optional.empty();
        private Optional<List<InvoicePaymentRequest>> paymentRequests = Optional.empty();
        private Optional<InvoiceDeliveryMethod> deliveryMethod = Optional.empty();
        private Optional<String> invoiceNumber = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> scheduledAt = Optional.empty();
        private Optional<String> publicUrl = Optional.empty();
        private Optional<Money> nextPaymentAmountMoney = Optional.empty();
        private Optional<InvoiceStatus> status = Optional.empty();
        private Optional<String> timezone = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<InvoiceAcceptedPaymentMethods> acceptedPaymentMethods = Optional.empty();
        private Optional<List<InvoiceCustomField>> customFields = Optional.empty();
        private Optional<String> subscriptionId = Optional.empty();
        private Optional<String> saleOrServiceDate = Optional.empty();
        private Optional<String> paymentConditions = Optional.empty();
        private Optional<Boolean> storePaymentMethodEnabled = Optional.empty();
        private Optional<List<InvoiceAttachment>> attachments = Optional.empty();
        private Optional<String> creatorTeamMemberId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Invoice other) {
            this.id(other.getId());
            this.version(other.getVersion());
            this.locationId(other.getLocationId());
            this.orderId(other.getOrderId());
            this.primaryRecipient(other.getPrimaryRecipient());
            this.paymentRequests(other.getPaymentRequests());
            this.deliveryMethod(other.getDeliveryMethod());
            this.invoiceNumber(other.getInvoiceNumber());
            this.title(other.getTitle());
            this.description(other.getDescription());
            this.scheduledAt(other.getScheduledAt());
            this.publicUrl(other.getPublicUrl());
            this.nextPaymentAmountMoney(other.getNextPaymentAmountMoney());
            this.status(other.getStatus());
            this.timezone(other.getTimezone());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.acceptedPaymentMethods(other.getAcceptedPaymentMethods());
            this.customFields(other.getCustomFields());
            this.subscriptionId(other.getSubscriptionId());
            this.saleOrServiceDate(other.getSaleOrServiceDate());
            this.paymentConditions(other.getPaymentConditions());
            this.storePaymentMethodEnabled(other.getStorePaymentMethodEnabled());
            this.attachments(other.getAttachments());
            this.creatorTeamMemberId(other.getCreatorTeamMemberId());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public Builder orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        public Builder orderId(Nullable<String> orderId) {
            this.orderId = orderId.isNull() ? null : (orderId.isEmpty() ? Optional.empty() : Optional.of(orderId.get()));
            return this;
        }

        @JsonSetter(value="primary_recipient", nulls=Nulls.SKIP)
        public Builder primaryRecipient(Optional<InvoiceRecipient> primaryRecipient) {
            this.primaryRecipient = primaryRecipient;
            return this;
        }

        public Builder primaryRecipient(InvoiceRecipient primaryRecipient) {
            this.primaryRecipient = Optional.ofNullable(primaryRecipient);
            return this;
        }

        @JsonSetter(value="payment_requests", nulls=Nulls.SKIP)
        public Builder paymentRequests(Optional<List<InvoicePaymentRequest>> paymentRequests) {
            this.paymentRequests = paymentRequests;
            return this;
        }

        public Builder paymentRequests(List<InvoicePaymentRequest> paymentRequests) {
            this.paymentRequests = Optional.ofNullable(paymentRequests);
            return this;
        }

        public Builder paymentRequests(Nullable<List<InvoicePaymentRequest>> paymentRequests) {
            this.paymentRequests = paymentRequests.isNull() ? null : (paymentRequests.isEmpty() ? Optional.empty() : Optional.of(paymentRequests.get()));
            return this;
        }

        @JsonSetter(value="delivery_method", nulls=Nulls.SKIP)
        public Builder deliveryMethod(Optional<InvoiceDeliveryMethod> deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        public Builder deliveryMethod(InvoiceDeliveryMethod deliveryMethod) {
            this.deliveryMethod = Optional.ofNullable(deliveryMethod);
            return this;
        }

        @JsonSetter(value="invoice_number", nulls=Nulls.SKIP)
        public Builder invoiceNumber(Optional<String> invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            return this;
        }

        public Builder invoiceNumber(String invoiceNumber) {
            this.invoiceNumber = Optional.ofNullable(invoiceNumber);
            return this;
        }

        public Builder invoiceNumber(Nullable<String> invoiceNumber) {
            this.invoiceNumber = invoiceNumber.isNull() ? null : (invoiceNumber.isEmpty() ? Optional.empty() : Optional.of(invoiceNumber.get()));
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        public Builder title(Nullable<String> title) {
            this.title = title.isNull() ? null : (title.isEmpty() ? Optional.empty() : Optional.of(title.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @JsonSetter(value="scheduled_at", nulls=Nulls.SKIP)
        public Builder scheduledAt(Optional<String> scheduledAt) {
            this.scheduledAt = scheduledAt;
            return this;
        }

        public Builder scheduledAt(String scheduledAt) {
            this.scheduledAt = Optional.ofNullable(scheduledAt);
            return this;
        }

        public Builder scheduledAt(Nullable<String> scheduledAt) {
            this.scheduledAt = scheduledAt.isNull() ? null : (scheduledAt.isEmpty() ? Optional.empty() : Optional.of(scheduledAt.get()));
            return this;
        }

        @JsonSetter(value="public_url", nulls=Nulls.SKIP)
        public Builder publicUrl(Optional<String> publicUrl) {
            this.publicUrl = publicUrl;
            return this;
        }

        public Builder publicUrl(String publicUrl) {
            this.publicUrl = Optional.ofNullable(publicUrl);
            return this;
        }

        @JsonSetter(value="next_payment_amount_money", nulls=Nulls.SKIP)
        public Builder nextPaymentAmountMoney(Optional<Money> nextPaymentAmountMoney) {
            this.nextPaymentAmountMoney = nextPaymentAmountMoney;
            return this;
        }

        public Builder nextPaymentAmountMoney(Money nextPaymentAmountMoney) {
            this.nextPaymentAmountMoney = Optional.ofNullable(nextPaymentAmountMoney);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<InvoiceStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(InvoiceStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="timezone", nulls=Nulls.SKIP)
        public Builder timezone(Optional<String> timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = Optional.ofNullable(timezone);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="accepted_payment_methods", nulls=Nulls.SKIP)
        public Builder acceptedPaymentMethods(Optional<InvoiceAcceptedPaymentMethods> acceptedPaymentMethods) {
            this.acceptedPaymentMethods = acceptedPaymentMethods;
            return this;
        }

        public Builder acceptedPaymentMethods(InvoiceAcceptedPaymentMethods acceptedPaymentMethods) {
            this.acceptedPaymentMethods = Optional.ofNullable(acceptedPaymentMethods);
            return this;
        }

        @JsonSetter(value="custom_fields", nulls=Nulls.SKIP)
        public Builder customFields(Optional<List<InvoiceCustomField>> customFields) {
            this.customFields = customFields;
            return this;
        }

        public Builder customFields(List<InvoiceCustomField> customFields) {
            this.customFields = Optional.ofNullable(customFields);
            return this;
        }

        public Builder customFields(Nullable<List<InvoiceCustomField>> customFields) {
            this.customFields = customFields.isNull() ? null : (customFields.isEmpty() ? Optional.empty() : Optional.of(customFields.get()));
            return this;
        }

        @JsonSetter(value="subscription_id", nulls=Nulls.SKIP)
        public Builder subscriptionId(Optional<String> subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = Optional.ofNullable(subscriptionId);
            return this;
        }

        @JsonSetter(value="sale_or_service_date", nulls=Nulls.SKIP)
        public Builder saleOrServiceDate(Optional<String> saleOrServiceDate) {
            this.saleOrServiceDate = saleOrServiceDate;
            return this;
        }

        public Builder saleOrServiceDate(String saleOrServiceDate) {
            this.saleOrServiceDate = Optional.ofNullable(saleOrServiceDate);
            return this;
        }

        public Builder saleOrServiceDate(Nullable<String> saleOrServiceDate) {
            this.saleOrServiceDate = saleOrServiceDate.isNull() ? null : (saleOrServiceDate.isEmpty() ? Optional.empty() : Optional.of(saleOrServiceDate.get()));
            return this;
        }

        @JsonSetter(value="payment_conditions", nulls=Nulls.SKIP)
        public Builder paymentConditions(Optional<String> paymentConditions) {
            this.paymentConditions = paymentConditions;
            return this;
        }

        public Builder paymentConditions(String paymentConditions) {
            this.paymentConditions = Optional.ofNullable(paymentConditions);
            return this;
        }

        public Builder paymentConditions(Nullable<String> paymentConditions) {
            this.paymentConditions = paymentConditions.isNull() ? null : (paymentConditions.isEmpty() ? Optional.empty() : Optional.of(paymentConditions.get()));
            return this;
        }

        @JsonSetter(value="store_payment_method_enabled", nulls=Nulls.SKIP)
        public Builder storePaymentMethodEnabled(Optional<Boolean> storePaymentMethodEnabled) {
            this.storePaymentMethodEnabled = storePaymentMethodEnabled;
            return this;
        }

        public Builder storePaymentMethodEnabled(Boolean storePaymentMethodEnabled) {
            this.storePaymentMethodEnabled = Optional.ofNullable(storePaymentMethodEnabled);
            return this;
        }

        public Builder storePaymentMethodEnabled(Nullable<Boolean> storePaymentMethodEnabled) {
            this.storePaymentMethodEnabled = storePaymentMethodEnabled.isNull() ? null : (storePaymentMethodEnabled.isEmpty() ? Optional.empty() : Optional.of(storePaymentMethodEnabled.get()));
            return this;
        }

        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public Builder attachments(Optional<List<InvoiceAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder attachments(List<InvoiceAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        @JsonSetter(value="creator_team_member_id", nulls=Nulls.SKIP)
        public Builder creatorTeamMemberId(Optional<String> creatorTeamMemberId) {
            this.creatorTeamMemberId = creatorTeamMemberId;
            return this;
        }

        public Builder creatorTeamMemberId(String creatorTeamMemberId) {
            this.creatorTeamMemberId = Optional.ofNullable(creatorTeamMemberId);
            return this;
        }

        public Invoice build() {
            return new Invoice(this.id, this.version, this.locationId, this.orderId, this.primaryRecipient, this.paymentRequests, this.deliveryMethod, this.invoiceNumber, this.title, this.description, this.scheduledAt, this.publicUrl, this.nextPaymentAmountMoney, this.status, this.timezone, this.createdAt, this.updatedAt, this.acceptedPaymentMethods, this.customFields, this.subscriptionId, this.saleOrServiceDate, this.paymentConditions, this.storePaymentMethodEnabled, this.attachments, this.creatorTeamMemberId, this.additionalProperties);
        }
    }
}

