/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class InventoryState {
    public static final InventoryState COMPOSED = new InventoryState(Value.COMPOSED, "COMPOSED");
    public static final InventoryState SOLD = new InventoryState(Value.SOLD, "SOLD");
    public static final InventoryState DECOMPOSED = new InventoryState(Value.DECOMPOSED, "DECOMPOSED");
    public static final InventoryState UNLINKED_RETURN = new InventoryState(Value.UNLINKED_RETURN, "UNLINKED_RETURN");
    public static final InventoryState RETURNED_BY_CUSTOMER = new InventoryState(Value.RETURNED_BY_CUSTOMER, "RETURNED_BY_CUSTOMER");
    public static final InventoryState NONE = new InventoryState(Value.NONE, "NONE");
    public static final InventoryState WASTE = new InventoryState(Value.WASTE, "WASTE");
    public static final InventoryState CUSTOM = new InventoryState(Value.CUSTOM, "CUSTOM");
    public static final InventoryState SUPPORTED_BY_NEWER_VERSION = new InventoryState(Value.SUPPORTED_BY_NEWER_VERSION, "SUPPORTED_BY_NEWER_VERSION");
    public static final InventoryState SOLD_ONLINE = new InventoryState(Value.SOLD_ONLINE, "SOLD_ONLINE");
    public static final InventoryState IN_TRANSIT = new InventoryState(Value.IN_TRANSIT, "IN_TRANSIT");
    public static final InventoryState RECEIVED_FROM_VENDOR = new InventoryState(Value.RECEIVED_FROM_VENDOR, "RECEIVED_FROM_VENDOR");
    public static final InventoryState RESERVED_FOR_SALE = new InventoryState(Value.RESERVED_FOR_SALE, "RESERVED_FOR_SALE");
    public static final InventoryState ORDERED_FROM_VENDOR = new InventoryState(Value.ORDERED_FROM_VENDOR, "ORDERED_FROM_VENDOR");
    public static final InventoryState IN_TRANSIT_TO = new InventoryState(Value.IN_TRANSIT_TO, "IN_TRANSIT_TO");
    public static final InventoryState IN_STOCK = new InventoryState(Value.IN_STOCK, "IN_STOCK");
    private final Value value;
    private final String string;

    InventoryState(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof InventoryState && this.string.equals(((InventoryState)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case COMPOSED: {
                return visitor.visitComposed();
            }
            case SOLD: {
                return visitor.visitSold();
            }
            case DECOMPOSED: {
                return visitor.visitDecomposed();
            }
            case UNLINKED_RETURN: {
                return visitor.visitUnlinkedReturn();
            }
            case RETURNED_BY_CUSTOMER: {
                return visitor.visitReturnedByCustomer();
            }
            case NONE: {
                return visitor.visitNone();
            }
            case WASTE: {
                return visitor.visitWaste();
            }
            case CUSTOM: {
                return visitor.visitCustom();
            }
            case SUPPORTED_BY_NEWER_VERSION: {
                return visitor.visitSupportedByNewerVersion();
            }
            case SOLD_ONLINE: {
                return visitor.visitSoldOnline();
            }
            case IN_TRANSIT: {
                return visitor.visitInTransit();
            }
            case RECEIVED_FROM_VENDOR: {
                return visitor.visitReceivedFromVendor();
            }
            case RESERVED_FOR_SALE: {
                return visitor.visitReservedForSale();
            }
            case ORDERED_FROM_VENDOR: {
                return visitor.visitOrderedFromVendor();
            }
            case IN_TRANSIT_TO: {
                return visitor.visitInTransitTo();
            }
            case IN_STOCK: {
                return visitor.visitInStock();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static InventoryState valueOf(String value) {
        switch (value) {
            case "COMPOSED": {
                return COMPOSED;
            }
            case "SOLD": {
                return SOLD;
            }
            case "DECOMPOSED": {
                return DECOMPOSED;
            }
            case "UNLINKED_RETURN": {
                return UNLINKED_RETURN;
            }
            case "RETURNED_BY_CUSTOMER": {
                return RETURNED_BY_CUSTOMER;
            }
            case "NONE": {
                return NONE;
            }
            case "WASTE": {
                return WASTE;
            }
            case "CUSTOM": {
                return CUSTOM;
            }
            case "SUPPORTED_BY_NEWER_VERSION": {
                return SUPPORTED_BY_NEWER_VERSION;
            }
            case "SOLD_ONLINE": {
                return SOLD_ONLINE;
            }
            case "IN_TRANSIT": {
                return IN_TRANSIT;
            }
            case "RECEIVED_FROM_VENDOR": {
                return RECEIVED_FROM_VENDOR;
            }
            case "RESERVED_FOR_SALE": {
                return RESERVED_FOR_SALE;
            }
            case "ORDERED_FROM_VENDOR": {
                return ORDERED_FROM_VENDOR;
            }
            case "IN_TRANSIT_TO": {
                return IN_TRANSIT_TO;
            }
            case "IN_STOCK": {
                return IN_STOCK;
            }
        }
        return new InventoryState(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitCustom();

        public T visitInStock();

        public T visitSold();

        public T visitReturnedByCustomer();

        public T visitReservedForSale();

        public T visitSoldOnline();

        public T visitOrderedFromVendor();

        public T visitReceivedFromVendor();

        public T visitInTransitTo();

        public T visitNone();

        public T visitWaste();

        public T visitUnlinkedReturn();

        public T visitComposed();

        public T visitDecomposed();

        public T visitSupportedByNewerVersion();

        public T visitInTransit();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        CUSTOM,
        IN_STOCK,
        SOLD,
        RETURNED_BY_CUSTOMER,
        RESERVED_FOR_SALE,
        SOLD_ONLINE,
        ORDERED_FROM_VENDOR,
        RECEIVED_FROM_VENDOR,
        IN_TRANSIT_TO,
        NONE,
        WASTE,
        UNLINKED_RETURN,
        COMPOSED,
        DECOMPOSED,
        SUPPORTED_BY_NEWER_VERSION,
        IN_TRANSIT,
        UNKNOWN;

    }
}

