/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InventoryState;
import com.squareup.square.types.SourceApplication;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InventoryPhysicalCount {
    private final Optional<String> id;
    private final Optional<String> referenceId;
    private final Optional<String> catalogObjectId;
    private final Optional<String> catalogObjectType;
    private final Optional<InventoryState> state;
    private final Optional<String> locationId;
    private final Optional<String> quantity;
    private final Optional<SourceApplication> source;
    private final Optional<String> employeeId;
    private final Optional<String> teamMemberId;
    private final Optional<String> occurredAt;
    private final Optional<String> createdAt;
    private final Map<String, Object> additionalProperties;

    private InventoryPhysicalCount(Optional<String> id, Optional<String> referenceId, Optional<String> catalogObjectId, Optional<String> catalogObjectType, Optional<InventoryState> state, Optional<String> locationId, Optional<String> quantity, Optional<SourceApplication> source, Optional<String> employeeId, Optional<String> teamMemberId, Optional<String> occurredAt, Optional<String> createdAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.referenceId = referenceId;
        this.catalogObjectId = catalogObjectId;
        this.catalogObjectType = catalogObjectType;
        this.state = state;
        this.locationId = locationId;
        this.quantity = quantity;
        this.source = source;
        this.employeeId = employeeId;
        this.teamMemberId = teamMemberId;
        this.occurredAt = occurredAt;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectId() {
        if (this.catalogObjectId == null) {
            return Optional.empty();
        }
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectType() {
        if (this.catalogObjectType == null) {
            return Optional.empty();
        }
        return this.catalogObjectType;
    }

    @JsonProperty(value="state")
    public Optional<InventoryState> getState() {
        return this.state;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getQuantity() {
        if (this.quantity == null) {
            return Optional.empty();
        }
        return this.quantity;
    }

    @JsonProperty(value="source")
    public Optional<SourceApplication> getSource() {
        return this.source;
    }

    @JsonIgnore
    public Optional<String> getEmployeeId() {
        if (this.employeeId == null) {
            return Optional.empty();
        }
        return this.employeeId;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonIgnore
    public Optional<String> getOccurredAt() {
        if (this.occurredAt == null) {
            return Optional.empty();
        }
        return this.occurredAt;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_id")
    private Optional<String> _getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_type")
    private Optional<String> _getCatalogObjectType() {
        return this.catalogObjectType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="quantity")
    private Optional<String> _getQuantity() {
        return this.quantity;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="employee_id")
    private Optional<String> _getEmployeeId() {
        return this.employeeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="occurred_at")
    private Optional<String> _getOccurredAt() {
        return this.occurredAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InventoryPhysicalCount && this.equalTo((InventoryPhysicalCount)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InventoryPhysicalCount other) {
        return this.id.equals(other.id) && this.referenceId.equals(other.referenceId) && this.catalogObjectId.equals(other.catalogObjectId) && this.catalogObjectType.equals(other.catalogObjectType) && this.state.equals(other.state) && this.locationId.equals(other.locationId) && this.quantity.equals(other.quantity) && this.source.equals(other.source) && this.employeeId.equals(other.employeeId) && this.teamMemberId.equals(other.teamMemberId) && this.occurredAt.equals(other.occurredAt) && this.createdAt.equals(other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.referenceId, this.catalogObjectId, this.catalogObjectType, this.state, this.locationId, this.quantity, this.source, this.employeeId, this.teamMemberId, this.occurredAt, this.createdAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> catalogObjectId = Optional.empty();
        private Optional<String> catalogObjectType = Optional.empty();
        private Optional<InventoryState> state = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> quantity = Optional.empty();
        private Optional<SourceApplication> source = Optional.empty();
        private Optional<String> employeeId = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> occurredAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InventoryPhysicalCount other) {
            this.id(other.getId());
            this.referenceId(other.getReferenceId());
            this.catalogObjectId(other.getCatalogObjectId());
            this.catalogObjectType(other.getCatalogObjectType());
            this.state(other.getState());
            this.locationId(other.getLocationId());
            this.quantity(other.getQuantity());
            this.source(other.getSource());
            this.employeeId(other.getEmployeeId());
            this.teamMemberId(other.getTeamMemberId());
            this.occurredAt(other.getOccurredAt());
            this.createdAt(other.getCreatedAt());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        public Builder referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_id", nulls=Nulls.SKIP)
        public Builder catalogObjectId(Optional<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = Optional.ofNullable(catalogObjectId);
            return this;
        }

        public Builder catalogObjectId(Nullable<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId.isNull() ? null : (catalogObjectId.isEmpty() ? Optional.empty() : Optional.of(catalogObjectId.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_type", nulls=Nulls.SKIP)
        public Builder catalogObjectType(Optional<String> catalogObjectType) {
            this.catalogObjectType = catalogObjectType;
            return this;
        }

        public Builder catalogObjectType(String catalogObjectType) {
            this.catalogObjectType = Optional.ofNullable(catalogObjectType);
            return this;
        }

        public Builder catalogObjectType(Nullable<String> catalogObjectType) {
            this.catalogObjectType = catalogObjectType.isNull() ? null : (catalogObjectType.isEmpty() ? Optional.empty() : Optional.of(catalogObjectType.get()));
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<InventoryState> state) {
            this.state = state;
            return this;
        }

        public Builder state(InventoryState state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public Builder quantity(Optional<String> quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        public Builder quantity(Nullable<String> quantity) {
            this.quantity = quantity.isNull() ? null : (quantity.isEmpty() ? Optional.empty() : Optional.of(quantity.get()));
            return this;
        }

        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public Builder source(Optional<SourceApplication> source) {
            this.source = source;
            return this;
        }

        public Builder source(SourceApplication source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @JsonSetter(value="employee_id", nulls=Nulls.SKIP)
        public Builder employeeId(Optional<String> employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = Optional.ofNullable(employeeId);
            return this;
        }

        public Builder employeeId(Nullable<String> employeeId) {
            this.employeeId = employeeId.isNull() ? null : (employeeId.isEmpty() ? Optional.empty() : Optional.of(employeeId.get()));
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        public Builder teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @JsonSetter(value="occurred_at", nulls=Nulls.SKIP)
        public Builder occurredAt(Optional<String> occurredAt) {
            this.occurredAt = occurredAt;
            return this;
        }

        public Builder occurredAt(String occurredAt) {
            this.occurredAt = Optional.ofNullable(occurredAt);
            return this;
        }

        public Builder occurredAt(Nullable<String> occurredAt) {
            this.occurredAt = occurredAt.isNull() ? null : (occurredAt.isEmpty() ? Optional.empty() : Optional.of(occurredAt.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        public InventoryPhysicalCount build() {
            return new InventoryPhysicalCount(this.id, this.referenceId, this.catalogObjectId, this.catalogObjectType, this.state, this.locationId, this.quantity, this.source, this.employeeId, this.teamMemberId, this.occurredAt, this.createdAt, this.additionalProperties);
        }
    }
}

