/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.InventoryState;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InventoryAdjustmentGroup {
    private final Optional<String> id;
    private final Optional<String> rootAdjustmentId;
    private final Optional<InventoryState> fromState;
    private final Optional<InventoryState> toState;
    private final Map<String, Object> additionalProperties;

    private InventoryAdjustmentGroup(Optional<String> id, Optional<String> rootAdjustmentId, Optional<InventoryState> fromState, Optional<InventoryState> toState, Map<String, Object> additionalProperties) {
        this.id = id;
        this.rootAdjustmentId = rootAdjustmentId;
        this.fromState = fromState;
        this.toState = toState;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="root_adjustment_id")
    public Optional<String> getRootAdjustmentId() {
        return this.rootAdjustmentId;
    }

    @JsonProperty(value="from_state")
    public Optional<InventoryState> getFromState() {
        return this.fromState;
    }

    @JsonProperty(value="to_state")
    public Optional<InventoryState> getToState() {
        return this.toState;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InventoryAdjustmentGroup && this.equalTo((InventoryAdjustmentGroup)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InventoryAdjustmentGroup other) {
        return this.id.equals(other.id) && this.rootAdjustmentId.equals(other.rootAdjustmentId) && this.fromState.equals(other.fromState) && this.toState.equals(other.toState);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rootAdjustmentId, this.fromState, this.toState);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> rootAdjustmentId = Optional.empty();
        private Optional<InventoryState> fromState = Optional.empty();
        private Optional<InventoryState> toState = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InventoryAdjustmentGroup other) {
            this.id(other.getId());
            this.rootAdjustmentId(other.getRootAdjustmentId());
            this.fromState(other.getFromState());
            this.toState(other.getToState());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="root_adjustment_id", nulls=Nulls.SKIP)
        public Builder rootAdjustmentId(Optional<String> rootAdjustmentId) {
            this.rootAdjustmentId = rootAdjustmentId;
            return this;
        }

        public Builder rootAdjustmentId(String rootAdjustmentId) {
            this.rootAdjustmentId = Optional.ofNullable(rootAdjustmentId);
            return this;
        }

        @JsonSetter(value="from_state", nulls=Nulls.SKIP)
        public Builder fromState(Optional<InventoryState> fromState) {
            this.fromState = fromState;
            return this;
        }

        public Builder fromState(InventoryState fromState) {
            this.fromState = Optional.ofNullable(fromState);
            return this;
        }

        @JsonSetter(value="to_state", nulls=Nulls.SKIP)
        public Builder toState(Optional<InventoryState> toState) {
            this.toState = toState;
            return this;
        }

        public Builder toState(InventoryState toState) {
            this.toState = Optional.ofNullable(toState);
            return this;
        }

        public InventoryAdjustmentGroup build() {
            return new InventoryAdjustmentGroup(this.id, this.rootAdjustmentId, this.fromState, this.toState, this.additionalProperties);
        }
    }
}

