/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class GiftCardType {
    public static final GiftCardType PHYSICAL = new GiftCardType(Value.PHYSICAL, "PHYSICAL");
    public static final GiftCardType DIGITAL = new GiftCardType(Value.DIGITAL, "DIGITAL");
    private final Value value;
    private final String string;

    GiftCardType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof GiftCardType && this.string.equals(((GiftCardType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case PHYSICAL: {
                return visitor.visitPhysical();
            }
            case DIGITAL: {
                return visitor.visitDigital();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static GiftCardType valueOf(String value) {
        switch (value) {
            case "PHYSICAL": {
                return PHYSICAL;
            }
            case "DIGITAL": {
                return DIGITAL;
            }
        }
        return new GiftCardType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitPhysical();

        public T visitDigital();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        PHYSICAL,
        DIGITAL,
        UNKNOWN;

    }
}

