/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCardActivityTransferBalanceTo {
    private final String transferFromGiftCardId;
    private final Money amountMoney;
    private final Map<String, Object> additionalProperties;

    private GiftCardActivityTransferBalanceTo(String transferFromGiftCardId, Money amountMoney, Map<String, Object> additionalProperties) {
        this.transferFromGiftCardId = transferFromGiftCardId;
        this.amountMoney = amountMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="transfer_from_gift_card_id")
    public String getTransferFromGiftCardId() {
        return this.transferFromGiftCardId;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCardActivityTransferBalanceTo && this.equalTo((GiftCardActivityTransferBalanceTo)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCardActivityTransferBalanceTo other) {
        return this.transferFromGiftCardId.equals(other.transferFromGiftCardId) && this.amountMoney.equals(other.amountMoney);
    }

    public int hashCode() {
        return Objects.hash(this.transferFromGiftCardId, this.amountMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TransferFromGiftCardIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TransferFromGiftCardIdStage,
    AmountMoneyStage,
    _FinalStage {
        private String transferFromGiftCardId;
        private Money amountMoney;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GiftCardActivityTransferBalanceTo other) {
            this.transferFromGiftCardId(other.getTransferFromGiftCardId());
            this.amountMoney(other.getAmountMoney());
            return this;
        }

        @Override
        @JsonSetter(value="transfer_from_gift_card_id")
        public AmountMoneyStage transferFromGiftCardId(@NotNull String transferFromGiftCardId) {
            this.transferFromGiftCardId = Objects.requireNonNull(transferFromGiftCardId, "transferFromGiftCardId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public _FinalStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        public GiftCardActivityTransferBalanceTo build() {
            return new GiftCardActivityTransferBalanceTo(this.transferFromGiftCardId, this.amountMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GiftCardActivityTransferBalanceTo build();
    }

    public static interface AmountMoneyStage {
        public _FinalStage amountMoney(@NotNull Money var1);
    }

    public static interface TransferFromGiftCardIdStage {
        public AmountMoneyStage transferFromGiftCardId(@NotNull String var1);

        public Builder from(GiftCardActivityTransferBalanceTo var1);
    }
}

