/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCardActivityLoad {
    private final Optional<Money> amountMoney;
    private final Optional<String> orderId;
    private final Optional<String> lineItemUid;
    private final Optional<String> referenceId;
    private final Optional<List<String>> buyerPaymentInstrumentIds;
    private final Map<String, Object> additionalProperties;

    private GiftCardActivityLoad(Optional<Money> amountMoney, Optional<String> orderId, Optional<String> lineItemUid, Optional<String> referenceId, Optional<List<String>> buyerPaymentInstrumentIds, Map<String, Object> additionalProperties) {
        this.amountMoney = amountMoney;
        this.orderId = orderId;
        this.lineItemUid = lineItemUid;
        this.referenceId = referenceId;
        this.buyerPaymentInstrumentIds = buyerPaymentInstrumentIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonIgnore
    public Optional<String> getOrderId() {
        if (this.orderId == null) {
            return Optional.empty();
        }
        return this.orderId;
    }

    @JsonIgnore
    public Optional<String> getLineItemUid() {
        if (this.lineItemUid == null) {
            return Optional.empty();
        }
        return this.lineItemUid;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonIgnore
    public Optional<List<String>> getBuyerPaymentInstrumentIds() {
        if (this.buyerPaymentInstrumentIds == null) {
            return Optional.empty();
        }
        return this.buyerPaymentInstrumentIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_id")
    private Optional<String> _getOrderId() {
        return this.orderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="line_item_uid")
    private Optional<String> _getLineItemUid() {
        return this.lineItemUid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="buyer_payment_instrument_ids")
    private Optional<List<String>> _getBuyerPaymentInstrumentIds() {
        return this.buyerPaymentInstrumentIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCardActivityLoad && this.equalTo((GiftCardActivityLoad)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCardActivityLoad other) {
        return this.amountMoney.equals(other.amountMoney) && this.orderId.equals(other.orderId) && this.lineItemUid.equals(other.lineItemUid) && this.referenceId.equals(other.referenceId) && this.buyerPaymentInstrumentIds.equals(other.buyerPaymentInstrumentIds);
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.orderId, this.lineItemUid, this.referenceId, this.buyerPaymentInstrumentIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        private Optional<String> lineItemUid = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<List<String>> buyerPaymentInstrumentIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GiftCardActivityLoad other) {
            this.amountMoney(other.getAmountMoney());
            this.orderId(other.getOrderId());
            this.lineItemUid(other.getLineItemUid());
            this.referenceId(other.getReferenceId());
            this.buyerPaymentInstrumentIds(other.getBuyerPaymentInstrumentIds());
            return this;
        }

        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public Builder amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public Builder orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        public Builder orderId(Nullable<String> orderId) {
            this.orderId = orderId.isNull() ? null : (orderId.isEmpty() ? Optional.empty() : Optional.of(orderId.get()));
            return this;
        }

        @JsonSetter(value="line_item_uid", nulls=Nulls.SKIP)
        public Builder lineItemUid(Optional<String> lineItemUid) {
            this.lineItemUid = lineItemUid;
            return this;
        }

        public Builder lineItemUid(String lineItemUid) {
            this.lineItemUid = Optional.ofNullable(lineItemUid);
            return this;
        }

        public Builder lineItemUid(Nullable<String> lineItemUid) {
            this.lineItemUid = lineItemUid.isNull() ? null : (lineItemUid.isEmpty() ? Optional.empty() : Optional.of(lineItemUid.get()));
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        public Builder referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @JsonSetter(value="buyer_payment_instrument_ids", nulls=Nulls.SKIP)
        public Builder buyerPaymentInstrumentIds(Optional<List<String>> buyerPaymentInstrumentIds) {
            this.buyerPaymentInstrumentIds = buyerPaymentInstrumentIds;
            return this;
        }

        public Builder buyerPaymentInstrumentIds(List<String> buyerPaymentInstrumentIds) {
            this.buyerPaymentInstrumentIds = Optional.ofNullable(buyerPaymentInstrumentIds);
            return this;
        }

        public Builder buyerPaymentInstrumentIds(Nullable<List<String>> buyerPaymentInstrumentIds) {
            this.buyerPaymentInstrumentIds = buyerPaymentInstrumentIds.isNull() ? null : (buyerPaymentInstrumentIds.isEmpty() ? Optional.empty() : Optional.of(buyerPaymentInstrumentIds.get()));
            return this;
        }

        public GiftCardActivityLoad build() {
            return new GiftCardActivityLoad(this.amountMoney, this.orderId, this.lineItemUid, this.referenceId, this.buyerPaymentInstrumentIds, this.additionalProperties);
        }
    }
}

