/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class GiftCardActivityAdjustDecrementReason {
    public static final GiftCardActivityAdjustDecrementReason BALANCE_ACCIDENTALLY_INCREASED = new GiftCardActivityAdjustDecrementReason(Value.BALANCE_ACCIDENTALLY_INCREASED, "BALANCE_ACCIDENTALLY_INCREASED");
    public static final GiftCardActivityAdjustDecrementReason PURCHASE_WAS_REFUNDED = new GiftCardActivityAdjustDecrementReason(Value.PURCHASE_WAS_REFUNDED, "PURCHASE_WAS_REFUNDED");
    public static final GiftCardActivityAdjustDecrementReason SUSPICIOUS_ACTIVITY = new GiftCardActivityAdjustDecrementReason(Value.SUSPICIOUS_ACTIVITY, "SUSPICIOUS_ACTIVITY");
    public static final GiftCardActivityAdjustDecrementReason SUPPORT_ISSUE = new GiftCardActivityAdjustDecrementReason(Value.SUPPORT_ISSUE, "SUPPORT_ISSUE");
    private final Value value;
    private final String string;

    GiftCardActivityAdjustDecrementReason(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof GiftCardActivityAdjustDecrementReason && this.string.equals(((GiftCardActivityAdjustDecrementReason)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case BALANCE_ACCIDENTALLY_INCREASED: {
                return visitor.visitBalanceAccidentallyIncreased();
            }
            case PURCHASE_WAS_REFUNDED: {
                return visitor.visitPurchaseWasRefunded();
            }
            case SUSPICIOUS_ACTIVITY: {
                return visitor.visitSuspiciousActivity();
            }
            case SUPPORT_ISSUE: {
                return visitor.visitSupportIssue();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static GiftCardActivityAdjustDecrementReason valueOf(String value) {
        switch (value) {
            case "BALANCE_ACCIDENTALLY_INCREASED": {
                return BALANCE_ACCIDENTALLY_INCREASED;
            }
            case "PURCHASE_WAS_REFUNDED": {
                return PURCHASE_WAS_REFUNDED;
            }
            case "SUSPICIOUS_ACTIVITY": {
                return SUSPICIOUS_ACTIVITY;
            }
            case "SUPPORT_ISSUE": {
                return SUPPORT_ISSUE;
            }
        }
        return new GiftCardActivityAdjustDecrementReason(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitSuspiciousActivity();

        public T visitBalanceAccidentallyIncreased();

        public T visitSupportIssue();

        public T visitPurchaseWasRefunded();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        SUSPICIOUS_ACTIVITY,
        BALANCE_ACCIDENTALLY_INCREASED,
        SUPPORT_ISSUE,
        PURCHASE_WAS_REFUNDED,
        UNKNOWN;

    }
}

