/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.GiftCardActivityAdjustDecrementReason;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCardActivityAdjustDecrement {
    private final Money amountMoney;
    private final GiftCardActivityAdjustDecrementReason reason;
    private final Map<String, Object> additionalProperties;

    private GiftCardActivityAdjustDecrement(Money amountMoney, GiftCardActivityAdjustDecrementReason reason, Map<String, Object> additionalProperties) {
        this.amountMoney = amountMoney;
        this.reason = reason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="reason")
    public GiftCardActivityAdjustDecrementReason getReason() {
        return this.reason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCardActivityAdjustDecrement && this.equalTo((GiftCardActivityAdjustDecrement)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCardActivityAdjustDecrement other) {
        return this.amountMoney.equals(other.amountMoney) && this.reason.equals(other.reason);
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.reason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountMoneyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountMoneyStage,
    ReasonStage,
    _FinalStage {
        private Money amountMoney;
        private GiftCardActivityAdjustDecrementReason reason;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GiftCardActivityAdjustDecrement other) {
            this.amountMoney(other.getAmountMoney());
            this.reason(other.getReason());
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public ReasonStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reason")
        public _FinalStage reason(@NotNull GiftCardActivityAdjustDecrementReason reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @Override
        public GiftCardActivityAdjustDecrement build() {
            return new GiftCardActivityAdjustDecrement(this.amountMoney, this.reason, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GiftCardActivityAdjustDecrement build();
    }

    public static interface ReasonStage {
        public _FinalStage reason(@NotNull GiftCardActivityAdjustDecrementReason var1);
    }

    public static interface AmountMoneyStage {
        public ReasonStage amountMoney(@NotNull Money var1);

        public Builder from(GiftCardActivityAdjustDecrement var1);
    }
}

