/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.GiftCardActivityActivate;
import com.squareup.square.types.GiftCardActivityAdjustDecrement;
import com.squareup.square.types.GiftCardActivityAdjustIncrement;
import com.squareup.square.types.GiftCardActivityBlock;
import com.squareup.square.types.GiftCardActivityClearBalance;
import com.squareup.square.types.GiftCardActivityDeactivate;
import com.squareup.square.types.GiftCardActivityImport;
import com.squareup.square.types.GiftCardActivityImportReversal;
import com.squareup.square.types.GiftCardActivityLoad;
import com.squareup.square.types.GiftCardActivityRedeem;
import com.squareup.square.types.GiftCardActivityRefund;
import com.squareup.square.types.GiftCardActivityTransferBalanceFrom;
import com.squareup.square.types.GiftCardActivityTransferBalanceTo;
import com.squareup.square.types.GiftCardActivityType;
import com.squareup.square.types.GiftCardActivityUnblock;
import com.squareup.square.types.GiftCardActivityUnlinkedActivityRefund;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GiftCardActivity {
    private final Optional<String> id;
    private final GiftCardActivityType type;
    private final String locationId;
    private final Optional<String> createdAt;
    private final Optional<String> giftCardId;
    private final Optional<String> giftCardGan;
    private final Optional<Money> giftCardBalanceMoney;
    private final Optional<GiftCardActivityLoad> loadActivityDetails;
    private final Optional<GiftCardActivityActivate> activateActivityDetails;
    private final Optional<GiftCardActivityRedeem> redeemActivityDetails;
    private final Optional<GiftCardActivityClearBalance> clearBalanceActivityDetails;
    private final Optional<GiftCardActivityDeactivate> deactivateActivityDetails;
    private final Optional<GiftCardActivityAdjustIncrement> adjustIncrementActivityDetails;
    private final Optional<GiftCardActivityAdjustDecrement> adjustDecrementActivityDetails;
    private final Optional<GiftCardActivityRefund> refundActivityDetails;
    private final Optional<GiftCardActivityUnlinkedActivityRefund> unlinkedActivityRefundActivityDetails;
    private final Optional<GiftCardActivityImport> importActivityDetails;
    private final Optional<GiftCardActivityBlock> blockActivityDetails;
    private final Optional<GiftCardActivityUnblock> unblockActivityDetails;
    private final Optional<GiftCardActivityImportReversal> importReversalActivityDetails;
    private final Optional<GiftCardActivityTransferBalanceTo> transferBalanceToActivityDetails;
    private final Optional<GiftCardActivityTransferBalanceFrom> transferBalanceFromActivityDetails;
    private final Map<String, Object> additionalProperties;

    private GiftCardActivity(Optional<String> id, GiftCardActivityType type, String locationId, Optional<String> createdAt, Optional<String> giftCardId, Optional<String> giftCardGan, Optional<Money> giftCardBalanceMoney, Optional<GiftCardActivityLoad> loadActivityDetails, Optional<GiftCardActivityActivate> activateActivityDetails, Optional<GiftCardActivityRedeem> redeemActivityDetails, Optional<GiftCardActivityClearBalance> clearBalanceActivityDetails, Optional<GiftCardActivityDeactivate> deactivateActivityDetails, Optional<GiftCardActivityAdjustIncrement> adjustIncrementActivityDetails, Optional<GiftCardActivityAdjustDecrement> adjustDecrementActivityDetails, Optional<GiftCardActivityRefund> refundActivityDetails, Optional<GiftCardActivityUnlinkedActivityRefund> unlinkedActivityRefundActivityDetails, Optional<GiftCardActivityImport> importActivityDetails, Optional<GiftCardActivityBlock> blockActivityDetails, Optional<GiftCardActivityUnblock> unblockActivityDetails, Optional<GiftCardActivityImportReversal> importReversalActivityDetails, Optional<GiftCardActivityTransferBalanceTo> transferBalanceToActivityDetails, Optional<GiftCardActivityTransferBalanceFrom> transferBalanceFromActivityDetails, Map<String, Object> additionalProperties) {
        this.id = id;
        this.type = type;
        this.locationId = locationId;
        this.createdAt = createdAt;
        this.giftCardId = giftCardId;
        this.giftCardGan = giftCardGan;
        this.giftCardBalanceMoney = giftCardBalanceMoney;
        this.loadActivityDetails = loadActivityDetails;
        this.activateActivityDetails = activateActivityDetails;
        this.redeemActivityDetails = redeemActivityDetails;
        this.clearBalanceActivityDetails = clearBalanceActivityDetails;
        this.deactivateActivityDetails = deactivateActivityDetails;
        this.adjustIncrementActivityDetails = adjustIncrementActivityDetails;
        this.adjustDecrementActivityDetails = adjustDecrementActivityDetails;
        this.refundActivityDetails = refundActivityDetails;
        this.unlinkedActivityRefundActivityDetails = unlinkedActivityRefundActivityDetails;
        this.importActivityDetails = importActivityDetails;
        this.blockActivityDetails = blockActivityDetails;
        this.unblockActivityDetails = unblockActivityDetails;
        this.importReversalActivityDetails = importReversalActivityDetails;
        this.transferBalanceToActivityDetails = transferBalanceToActivityDetails;
        this.transferBalanceFromActivityDetails = transferBalanceFromActivityDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public GiftCardActivityType getType() {
        return this.type;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<String> getGiftCardId() {
        if (this.giftCardId == null) {
            return Optional.empty();
        }
        return this.giftCardId;
    }

    @JsonIgnore
    public Optional<String> getGiftCardGan() {
        if (this.giftCardGan == null) {
            return Optional.empty();
        }
        return this.giftCardGan;
    }

    @JsonProperty(value="gift_card_balance_money")
    public Optional<Money> getGiftCardBalanceMoney() {
        return this.giftCardBalanceMoney;
    }

    @JsonProperty(value="load_activity_details")
    public Optional<GiftCardActivityLoad> getLoadActivityDetails() {
        return this.loadActivityDetails;
    }

    @JsonProperty(value="activate_activity_details")
    public Optional<GiftCardActivityActivate> getActivateActivityDetails() {
        return this.activateActivityDetails;
    }

    @JsonProperty(value="redeem_activity_details")
    public Optional<GiftCardActivityRedeem> getRedeemActivityDetails() {
        return this.redeemActivityDetails;
    }

    @JsonProperty(value="clear_balance_activity_details")
    public Optional<GiftCardActivityClearBalance> getClearBalanceActivityDetails() {
        return this.clearBalanceActivityDetails;
    }

    @JsonProperty(value="deactivate_activity_details")
    public Optional<GiftCardActivityDeactivate> getDeactivateActivityDetails() {
        return this.deactivateActivityDetails;
    }

    @JsonProperty(value="adjust_increment_activity_details")
    public Optional<GiftCardActivityAdjustIncrement> getAdjustIncrementActivityDetails() {
        return this.adjustIncrementActivityDetails;
    }

    @JsonProperty(value="adjust_decrement_activity_details")
    public Optional<GiftCardActivityAdjustDecrement> getAdjustDecrementActivityDetails() {
        return this.adjustDecrementActivityDetails;
    }

    @JsonProperty(value="refund_activity_details")
    public Optional<GiftCardActivityRefund> getRefundActivityDetails() {
        return this.refundActivityDetails;
    }

    @JsonProperty(value="unlinked_activity_refund_activity_details")
    public Optional<GiftCardActivityUnlinkedActivityRefund> getUnlinkedActivityRefundActivityDetails() {
        return this.unlinkedActivityRefundActivityDetails;
    }

    @JsonProperty(value="import_activity_details")
    public Optional<GiftCardActivityImport> getImportActivityDetails() {
        return this.importActivityDetails;
    }

    @JsonProperty(value="block_activity_details")
    public Optional<GiftCardActivityBlock> getBlockActivityDetails() {
        return this.blockActivityDetails;
    }

    @JsonProperty(value="unblock_activity_details")
    public Optional<GiftCardActivityUnblock> getUnblockActivityDetails() {
        return this.unblockActivityDetails;
    }

    @JsonProperty(value="import_reversal_activity_details")
    public Optional<GiftCardActivityImportReversal> getImportReversalActivityDetails() {
        return this.importReversalActivityDetails;
    }

    @JsonProperty(value="transfer_balance_to_activity_details")
    public Optional<GiftCardActivityTransferBalanceTo> getTransferBalanceToActivityDetails() {
        return this.transferBalanceToActivityDetails;
    }

    @JsonProperty(value="transfer_balance_from_activity_details")
    public Optional<GiftCardActivityTransferBalanceFrom> getTransferBalanceFromActivityDetails() {
        return this.transferBalanceFromActivityDetails;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="gift_card_id")
    private Optional<String> _getGiftCardId() {
        return this.giftCardId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="gift_card_gan")
    private Optional<String> _getGiftCardGan() {
        return this.giftCardGan;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GiftCardActivity && this.equalTo((GiftCardActivity)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GiftCardActivity other) {
        return this.id.equals(other.id) && this.type.equals(other.type) && this.locationId.equals(other.locationId) && this.createdAt.equals(other.createdAt) && this.giftCardId.equals(other.giftCardId) && this.giftCardGan.equals(other.giftCardGan) && this.giftCardBalanceMoney.equals(other.giftCardBalanceMoney) && this.loadActivityDetails.equals(other.loadActivityDetails) && this.activateActivityDetails.equals(other.activateActivityDetails) && this.redeemActivityDetails.equals(other.redeemActivityDetails) && this.clearBalanceActivityDetails.equals(other.clearBalanceActivityDetails) && this.deactivateActivityDetails.equals(other.deactivateActivityDetails) && this.adjustIncrementActivityDetails.equals(other.adjustIncrementActivityDetails) && this.adjustDecrementActivityDetails.equals(other.adjustDecrementActivityDetails) && this.refundActivityDetails.equals(other.refundActivityDetails) && this.unlinkedActivityRefundActivityDetails.equals(other.unlinkedActivityRefundActivityDetails) && this.importActivityDetails.equals(other.importActivityDetails) && this.blockActivityDetails.equals(other.blockActivityDetails) && this.unblockActivityDetails.equals(other.unblockActivityDetails) && this.importReversalActivityDetails.equals(other.importReversalActivityDetails) && this.transferBalanceToActivityDetails.equals(other.transferBalanceToActivityDetails) && this.transferBalanceFromActivityDetails.equals(other.transferBalanceFromActivityDetails);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.locationId, this.createdAt, this.giftCardId, this.giftCardGan, this.giftCardBalanceMoney, this.loadActivityDetails, this.activateActivityDetails, this.redeemActivityDetails, this.clearBalanceActivityDetails, this.deactivateActivityDetails, this.adjustIncrementActivityDetails, this.adjustDecrementActivityDetails, this.refundActivityDetails, this.unlinkedActivityRefundActivityDetails, this.importActivityDetails, this.blockActivityDetails, this.unblockActivityDetails, this.importReversalActivityDetails, this.transferBalanceToActivityDetails, this.transferBalanceFromActivityDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    LocationIdStage,
    _FinalStage {
        private GiftCardActivityType type;
        private String locationId;
        private Optional<GiftCardActivityTransferBalanceFrom> transferBalanceFromActivityDetails = Optional.empty();
        private Optional<GiftCardActivityTransferBalanceTo> transferBalanceToActivityDetails = Optional.empty();
        private Optional<GiftCardActivityImportReversal> importReversalActivityDetails = Optional.empty();
        private Optional<GiftCardActivityUnblock> unblockActivityDetails = Optional.empty();
        private Optional<GiftCardActivityBlock> blockActivityDetails = Optional.empty();
        private Optional<GiftCardActivityImport> importActivityDetails = Optional.empty();
        private Optional<GiftCardActivityUnlinkedActivityRefund> unlinkedActivityRefundActivityDetails = Optional.empty();
        private Optional<GiftCardActivityRefund> refundActivityDetails = Optional.empty();
        private Optional<GiftCardActivityAdjustDecrement> adjustDecrementActivityDetails = Optional.empty();
        private Optional<GiftCardActivityAdjustIncrement> adjustIncrementActivityDetails = Optional.empty();
        private Optional<GiftCardActivityDeactivate> deactivateActivityDetails = Optional.empty();
        private Optional<GiftCardActivityClearBalance> clearBalanceActivityDetails = Optional.empty();
        private Optional<GiftCardActivityRedeem> redeemActivityDetails = Optional.empty();
        private Optional<GiftCardActivityActivate> activateActivityDetails = Optional.empty();
        private Optional<GiftCardActivityLoad> loadActivityDetails = Optional.empty();
        private Optional<Money> giftCardBalanceMoney = Optional.empty();
        private Optional<String> giftCardGan = Optional.empty();
        private Optional<String> giftCardId = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GiftCardActivity other) {
            this.id(other.getId());
            this.type(other.getType());
            this.locationId(other.getLocationId());
            this.createdAt(other.getCreatedAt());
            this.giftCardId(other.getGiftCardId());
            this.giftCardGan(other.getGiftCardGan());
            this.giftCardBalanceMoney(other.getGiftCardBalanceMoney());
            this.loadActivityDetails(other.getLoadActivityDetails());
            this.activateActivityDetails(other.getActivateActivityDetails());
            this.redeemActivityDetails(other.getRedeemActivityDetails());
            this.clearBalanceActivityDetails(other.getClearBalanceActivityDetails());
            this.deactivateActivityDetails(other.getDeactivateActivityDetails());
            this.adjustIncrementActivityDetails(other.getAdjustIncrementActivityDetails());
            this.adjustDecrementActivityDetails(other.getAdjustDecrementActivityDetails());
            this.refundActivityDetails(other.getRefundActivityDetails());
            this.unlinkedActivityRefundActivityDetails(other.getUnlinkedActivityRefundActivityDetails());
            this.importActivityDetails(other.getImportActivityDetails());
            this.blockActivityDetails(other.getBlockActivityDetails());
            this.unblockActivityDetails(other.getUnblockActivityDetails());
            this.importReversalActivityDetails(other.getImportReversalActivityDetails());
            this.transferBalanceToActivityDetails(other.getTransferBalanceToActivityDetails());
            this.transferBalanceFromActivityDetails(other.getTransferBalanceFromActivityDetails());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public LocationIdStage type(@NotNull GiftCardActivityType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public _FinalStage transferBalanceFromActivityDetails(GiftCardActivityTransferBalanceFrom transferBalanceFromActivityDetails) {
            this.transferBalanceFromActivityDetails = Optional.ofNullable(transferBalanceFromActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="transfer_balance_from_activity_details", nulls=Nulls.SKIP)
        public _FinalStage transferBalanceFromActivityDetails(Optional<GiftCardActivityTransferBalanceFrom> transferBalanceFromActivityDetails) {
            this.transferBalanceFromActivityDetails = transferBalanceFromActivityDetails;
            return this;
        }

        @Override
        public _FinalStage transferBalanceToActivityDetails(GiftCardActivityTransferBalanceTo transferBalanceToActivityDetails) {
            this.transferBalanceToActivityDetails = Optional.ofNullable(transferBalanceToActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="transfer_balance_to_activity_details", nulls=Nulls.SKIP)
        public _FinalStage transferBalanceToActivityDetails(Optional<GiftCardActivityTransferBalanceTo> transferBalanceToActivityDetails) {
            this.transferBalanceToActivityDetails = transferBalanceToActivityDetails;
            return this;
        }

        @Override
        public _FinalStage importReversalActivityDetails(GiftCardActivityImportReversal importReversalActivityDetails) {
            this.importReversalActivityDetails = Optional.ofNullable(importReversalActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="import_reversal_activity_details", nulls=Nulls.SKIP)
        public _FinalStage importReversalActivityDetails(Optional<GiftCardActivityImportReversal> importReversalActivityDetails) {
            this.importReversalActivityDetails = importReversalActivityDetails;
            return this;
        }

        @Override
        public _FinalStage unblockActivityDetails(GiftCardActivityUnblock unblockActivityDetails) {
            this.unblockActivityDetails = Optional.ofNullable(unblockActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="unblock_activity_details", nulls=Nulls.SKIP)
        public _FinalStage unblockActivityDetails(Optional<GiftCardActivityUnblock> unblockActivityDetails) {
            this.unblockActivityDetails = unblockActivityDetails;
            return this;
        }

        @Override
        public _FinalStage blockActivityDetails(GiftCardActivityBlock blockActivityDetails) {
            this.blockActivityDetails = Optional.ofNullable(blockActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="block_activity_details", nulls=Nulls.SKIP)
        public _FinalStage blockActivityDetails(Optional<GiftCardActivityBlock> blockActivityDetails) {
            this.blockActivityDetails = blockActivityDetails;
            return this;
        }

        @Override
        public _FinalStage importActivityDetails(GiftCardActivityImport importActivityDetails) {
            this.importActivityDetails = Optional.ofNullable(importActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="import_activity_details", nulls=Nulls.SKIP)
        public _FinalStage importActivityDetails(Optional<GiftCardActivityImport> importActivityDetails) {
            this.importActivityDetails = importActivityDetails;
            return this;
        }

        @Override
        public _FinalStage unlinkedActivityRefundActivityDetails(GiftCardActivityUnlinkedActivityRefund unlinkedActivityRefundActivityDetails) {
            this.unlinkedActivityRefundActivityDetails = Optional.ofNullable(unlinkedActivityRefundActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="unlinked_activity_refund_activity_details", nulls=Nulls.SKIP)
        public _FinalStage unlinkedActivityRefundActivityDetails(Optional<GiftCardActivityUnlinkedActivityRefund> unlinkedActivityRefundActivityDetails) {
            this.unlinkedActivityRefundActivityDetails = unlinkedActivityRefundActivityDetails;
            return this;
        }

        @Override
        public _FinalStage refundActivityDetails(GiftCardActivityRefund refundActivityDetails) {
            this.refundActivityDetails = Optional.ofNullable(refundActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="refund_activity_details", nulls=Nulls.SKIP)
        public _FinalStage refundActivityDetails(Optional<GiftCardActivityRefund> refundActivityDetails) {
            this.refundActivityDetails = refundActivityDetails;
            return this;
        }

        @Override
        public _FinalStage adjustDecrementActivityDetails(GiftCardActivityAdjustDecrement adjustDecrementActivityDetails) {
            this.adjustDecrementActivityDetails = Optional.ofNullable(adjustDecrementActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="adjust_decrement_activity_details", nulls=Nulls.SKIP)
        public _FinalStage adjustDecrementActivityDetails(Optional<GiftCardActivityAdjustDecrement> adjustDecrementActivityDetails) {
            this.adjustDecrementActivityDetails = adjustDecrementActivityDetails;
            return this;
        }

        @Override
        public _FinalStage adjustIncrementActivityDetails(GiftCardActivityAdjustIncrement adjustIncrementActivityDetails) {
            this.adjustIncrementActivityDetails = Optional.ofNullable(adjustIncrementActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="adjust_increment_activity_details", nulls=Nulls.SKIP)
        public _FinalStage adjustIncrementActivityDetails(Optional<GiftCardActivityAdjustIncrement> adjustIncrementActivityDetails) {
            this.adjustIncrementActivityDetails = adjustIncrementActivityDetails;
            return this;
        }

        @Override
        public _FinalStage deactivateActivityDetails(GiftCardActivityDeactivate deactivateActivityDetails) {
            this.deactivateActivityDetails = Optional.ofNullable(deactivateActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="deactivate_activity_details", nulls=Nulls.SKIP)
        public _FinalStage deactivateActivityDetails(Optional<GiftCardActivityDeactivate> deactivateActivityDetails) {
            this.deactivateActivityDetails = deactivateActivityDetails;
            return this;
        }

        @Override
        public _FinalStage clearBalanceActivityDetails(GiftCardActivityClearBalance clearBalanceActivityDetails) {
            this.clearBalanceActivityDetails = Optional.ofNullable(clearBalanceActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="clear_balance_activity_details", nulls=Nulls.SKIP)
        public _FinalStage clearBalanceActivityDetails(Optional<GiftCardActivityClearBalance> clearBalanceActivityDetails) {
            this.clearBalanceActivityDetails = clearBalanceActivityDetails;
            return this;
        }

        @Override
        public _FinalStage redeemActivityDetails(GiftCardActivityRedeem redeemActivityDetails) {
            this.redeemActivityDetails = Optional.ofNullable(redeemActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="redeem_activity_details", nulls=Nulls.SKIP)
        public _FinalStage redeemActivityDetails(Optional<GiftCardActivityRedeem> redeemActivityDetails) {
            this.redeemActivityDetails = redeemActivityDetails;
            return this;
        }

        @Override
        public _FinalStage activateActivityDetails(GiftCardActivityActivate activateActivityDetails) {
            this.activateActivityDetails = Optional.ofNullable(activateActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="activate_activity_details", nulls=Nulls.SKIP)
        public _FinalStage activateActivityDetails(Optional<GiftCardActivityActivate> activateActivityDetails) {
            this.activateActivityDetails = activateActivityDetails;
            return this;
        }

        @Override
        public _FinalStage loadActivityDetails(GiftCardActivityLoad loadActivityDetails) {
            this.loadActivityDetails = Optional.ofNullable(loadActivityDetails);
            return this;
        }

        @Override
        @JsonSetter(value="load_activity_details", nulls=Nulls.SKIP)
        public _FinalStage loadActivityDetails(Optional<GiftCardActivityLoad> loadActivityDetails) {
            this.loadActivityDetails = loadActivityDetails;
            return this;
        }

        @Override
        public _FinalStage giftCardBalanceMoney(Money giftCardBalanceMoney) {
            this.giftCardBalanceMoney = Optional.ofNullable(giftCardBalanceMoney);
            return this;
        }

        @Override
        @JsonSetter(value="gift_card_balance_money", nulls=Nulls.SKIP)
        public _FinalStage giftCardBalanceMoney(Optional<Money> giftCardBalanceMoney) {
            this.giftCardBalanceMoney = giftCardBalanceMoney;
            return this;
        }

        @Override
        public _FinalStage giftCardGan(Nullable<String> giftCardGan) {
            this.giftCardGan = giftCardGan.isNull() ? null : (giftCardGan.isEmpty() ? Optional.empty() : Optional.of(giftCardGan.get()));
            return this;
        }

        @Override
        public _FinalStage giftCardGan(String giftCardGan) {
            this.giftCardGan = Optional.ofNullable(giftCardGan);
            return this;
        }

        @Override
        @JsonSetter(value="gift_card_gan", nulls=Nulls.SKIP)
        public _FinalStage giftCardGan(Optional<String> giftCardGan) {
            this.giftCardGan = giftCardGan;
            return this;
        }

        @Override
        public _FinalStage giftCardId(Nullable<String> giftCardId) {
            this.giftCardId = giftCardId.isNull() ? null : (giftCardId.isEmpty() ? Optional.empty() : Optional.of(giftCardId.get()));
            return this;
        }

        @Override
        public _FinalStage giftCardId(String giftCardId) {
            this.giftCardId = Optional.ofNullable(giftCardId);
            return this;
        }

        @Override
        @JsonSetter(value="gift_card_id", nulls=Nulls.SKIP)
        public _FinalStage giftCardId(Optional<String> giftCardId) {
            this.giftCardId = giftCardId;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public GiftCardActivity build() {
            return new GiftCardActivity(this.id, this.type, this.locationId, this.createdAt, this.giftCardId, this.giftCardGan, this.giftCardBalanceMoney, this.loadActivityDetails, this.activateActivityDetails, this.redeemActivityDetails, this.clearBalanceActivityDetails, this.deactivateActivityDetails, this.adjustIncrementActivityDetails, this.adjustDecrementActivityDetails, this.refundActivityDetails, this.unlinkedActivityRefundActivityDetails, this.importActivityDetails, this.blockActivityDetails, this.unblockActivityDetails, this.importReversalActivityDetails, this.transferBalanceToActivityDetails, this.transferBalanceFromActivityDetails, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GiftCardActivity build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage giftCardId(Optional<String> var1);

        public _FinalStage giftCardId(String var1);

        public _FinalStage giftCardId(Nullable<String> var1);

        public _FinalStage giftCardGan(Optional<String> var1);

        public _FinalStage giftCardGan(String var1);

        public _FinalStage giftCardGan(Nullable<String> var1);

        public _FinalStage giftCardBalanceMoney(Optional<Money> var1);

        public _FinalStage giftCardBalanceMoney(Money var1);

        public _FinalStage loadActivityDetails(Optional<GiftCardActivityLoad> var1);

        public _FinalStage loadActivityDetails(GiftCardActivityLoad var1);

        public _FinalStage activateActivityDetails(Optional<GiftCardActivityActivate> var1);

        public _FinalStage activateActivityDetails(GiftCardActivityActivate var1);

        public _FinalStage redeemActivityDetails(Optional<GiftCardActivityRedeem> var1);

        public _FinalStage redeemActivityDetails(GiftCardActivityRedeem var1);

        public _FinalStage clearBalanceActivityDetails(Optional<GiftCardActivityClearBalance> var1);

        public _FinalStage clearBalanceActivityDetails(GiftCardActivityClearBalance var1);

        public _FinalStage deactivateActivityDetails(Optional<GiftCardActivityDeactivate> var1);

        public _FinalStage deactivateActivityDetails(GiftCardActivityDeactivate var1);

        public _FinalStage adjustIncrementActivityDetails(Optional<GiftCardActivityAdjustIncrement> var1);

        public _FinalStage adjustIncrementActivityDetails(GiftCardActivityAdjustIncrement var1);

        public _FinalStage adjustDecrementActivityDetails(Optional<GiftCardActivityAdjustDecrement> var1);

        public _FinalStage adjustDecrementActivityDetails(GiftCardActivityAdjustDecrement var1);

        public _FinalStage refundActivityDetails(Optional<GiftCardActivityRefund> var1);

        public _FinalStage refundActivityDetails(GiftCardActivityRefund var1);

        public _FinalStage unlinkedActivityRefundActivityDetails(Optional<GiftCardActivityUnlinkedActivityRefund> var1);

        public _FinalStage unlinkedActivityRefundActivityDetails(GiftCardActivityUnlinkedActivityRefund var1);

        public _FinalStage importActivityDetails(Optional<GiftCardActivityImport> var1);

        public _FinalStage importActivityDetails(GiftCardActivityImport var1);

        public _FinalStage blockActivityDetails(Optional<GiftCardActivityBlock> var1);

        public _FinalStage blockActivityDetails(GiftCardActivityBlock var1);

        public _FinalStage unblockActivityDetails(Optional<GiftCardActivityUnblock> var1);

        public _FinalStage unblockActivityDetails(GiftCardActivityUnblock var1);

        public _FinalStage importReversalActivityDetails(Optional<GiftCardActivityImportReversal> var1);

        public _FinalStage importReversalActivityDetails(GiftCardActivityImportReversal var1);

        public _FinalStage transferBalanceToActivityDetails(Optional<GiftCardActivityTransferBalanceTo> var1);

        public _FinalStage transferBalanceToActivityDetails(GiftCardActivityTransferBalanceTo var1);

        public _FinalStage transferBalanceFromActivityDetails(Optional<GiftCardActivityTransferBalanceFrom> var1);

        public _FinalStage transferBalanceFromActivityDetails(GiftCardActivityTransferBalanceFrom var1);
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);
    }

    public static interface TypeStage {
        public LocationIdStage type(@NotNull GiftCardActivityType var1);

        public Builder from(GiftCardActivity var1);
    }
}

