/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Transaction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetTransactionResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Transaction> transaction;
    private final Map<String, Object> additionalProperties;

    private GetTransactionResponse(Optional<List<Error>> errors, Optional<Transaction> transaction, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.transaction = transaction;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="transaction")
    public Optional<Transaction> getTransaction() {
        return this.transaction;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetTransactionResponse && this.equalTo((GetTransactionResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetTransactionResponse other) {
        return this.errors.equals(other.errors) && this.transaction.equals(other.transaction);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.transaction);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Transaction> transaction = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetTransactionResponse other) {
            this.errors(other.getErrors());
            this.transaction(other.getTransaction());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="transaction", nulls=Nulls.SKIP)
        public Builder transaction(Optional<Transaction> transaction) {
            this.transaction = transaction;
            return this;
        }

        public Builder transaction(Transaction transaction) {
            this.transaction = Optional.ofNullable(transaction);
            return this;
        }

        public GetTransactionResponse build() {
            return new GetTransactionResponse(this.errors, this.transaction, this.additionalProperties);
        }
    }
}

