/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCustomersRequest {
    private final String customerId;
    private final Map<String, Object> additionalProperties;

    private GetCustomersRequest(String customerId, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCustomersRequest && this.equalTo((GetCustomersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCustomersRequest other) {
        return this.customerId.equals(other.customerId);
    }

    public int hashCode() {
        return Objects.hash(this.customerId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerIdStage,
    _FinalStage {
        private String customerId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetCustomersRequest other) {
            this.customerId(other.getCustomerId());
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public _FinalStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        public GetCustomersRequest build() {
            return new GetCustomersRequest(this.customerId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetCustomersRequest build();
    }

    public static interface CustomerIdStage {
        public _FinalStage customerId(@NotNull String var1);

        public Builder from(GetCustomersRequest var1);
    }
}

