/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerSegment;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCustomerSegmentResponse {
    private final Optional<List<Error>> errors;
    private final Optional<CustomerSegment> segment;
    private final Map<String, Object> additionalProperties;

    private GetCustomerSegmentResponse(Optional<List<Error>> errors, Optional<CustomerSegment> segment, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.segment = segment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="segment")
    public Optional<CustomerSegment> getSegment() {
        return this.segment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCustomerSegmentResponse && this.equalTo((GetCustomerSegmentResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCustomerSegmentResponse other) {
        return this.errors.equals(other.errors) && this.segment.equals(other.segment);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.segment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<CustomerSegment> segment = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetCustomerSegmentResponse other) {
            this.errors(other.getErrors());
            this.segment(other.getSegment());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="segment", nulls=Nulls.SKIP)
        public Builder segment(Optional<CustomerSegment> segment) {
            this.segment = segment;
            return this;
        }

        public Builder segment(CustomerSegment segment) {
            this.segment = Optional.ofNullable(segment);
            return this;
        }

        public GetCustomerSegmentResponse build() {
            return new GetCustomerSegmentResponse(this.errors, this.segment, this.additionalProperties);
        }
    }
}

