/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Customer;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCustomerResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Customer> customer;
    private final Map<String, Object> additionalProperties;

    private GetCustomerResponse(Optional<List<Error>> errors, Optional<Customer> customer, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.customer = customer;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="customer")
    public Optional<Customer> getCustomer() {
        return this.customer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCustomerResponse && this.equalTo((GetCustomerResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCustomerResponse other) {
        return this.errors.equals(other.errors) && this.customer.equals(other.customer);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.customer);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Customer> customer = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetCustomerResponse other) {
            this.errors(other.getErrors());
            this.customer(other.getCustomer());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="customer", nulls=Nulls.SKIP)
        public Builder customer(Optional<Customer> customer) {
            this.customer = customer;
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = Optional.ofNullable(customer);
            return this;
        }

        public GetCustomerResponse build() {
            return new GetCustomerResponse(this.errors, this.customer, this.additionalProperties);
        }
    }
}

