/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CashDrawerShift;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCashDrawerShiftResponse {
    private final Optional<CashDrawerShift> cashDrawerShift;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private GetCashDrawerShiftResponse(Optional<CashDrawerShift> cashDrawerShift, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.cashDrawerShift = cashDrawerShift;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cash_drawer_shift")
    public Optional<CashDrawerShift> getCashDrawerShift() {
        return this.cashDrawerShift;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCashDrawerShiftResponse && this.equalTo((GetCashDrawerShiftResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCashDrawerShiftResponse other) {
        return this.cashDrawerShift.equals(other.cashDrawerShift) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.cashDrawerShift, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CashDrawerShift> cashDrawerShift = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetCashDrawerShiftResponse other) {
            this.cashDrawerShift(other.getCashDrawerShift());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="cash_drawer_shift", nulls=Nulls.SKIP)
        public Builder cashDrawerShift(Optional<CashDrawerShift> cashDrawerShift) {
            this.cashDrawerShift = cashDrawerShift;
            return this;
        }

        public Builder cashDrawerShift(CashDrawerShift cashDrawerShift) {
            this.cashDrawerShift = Optional.ofNullable(cashDrawerShift);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public GetCashDrawerShiftResponse build() {
            return new GetCashDrawerShiftResponse(this.cashDrawerShift, this.errors, this.additionalProperties);
        }
    }
}

