/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.FulfillmentRecipient;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FulfillmentShipmentDetails {
    private final Optional<FulfillmentRecipient> recipient;
    private final Optional<String> carrier;
    private final Optional<String> shippingNote;
    private final Optional<String> shippingType;
    private final Optional<String> trackingNumber;
    private final Optional<String> trackingUrl;
    private final Optional<String> placedAt;
    private final Optional<String> inProgressAt;
    private final Optional<String> packagedAt;
    private final Optional<String> expectedShippedAt;
    private final Optional<String> shippedAt;
    private final Optional<String> canceledAt;
    private final Optional<String> cancelReason;
    private final Optional<String> failedAt;
    private final Optional<String> failureReason;
    private final Map<String, Object> additionalProperties;

    private FulfillmentShipmentDetails(Optional<FulfillmentRecipient> recipient, Optional<String> carrier, Optional<String> shippingNote, Optional<String> shippingType, Optional<String> trackingNumber, Optional<String> trackingUrl, Optional<String> placedAt, Optional<String> inProgressAt, Optional<String> packagedAt, Optional<String> expectedShippedAt, Optional<String> shippedAt, Optional<String> canceledAt, Optional<String> cancelReason, Optional<String> failedAt, Optional<String> failureReason, Map<String, Object> additionalProperties) {
        this.recipient = recipient;
        this.carrier = carrier;
        this.shippingNote = shippingNote;
        this.shippingType = shippingType;
        this.trackingNumber = trackingNumber;
        this.trackingUrl = trackingUrl;
        this.placedAt = placedAt;
        this.inProgressAt = inProgressAt;
        this.packagedAt = packagedAt;
        this.expectedShippedAt = expectedShippedAt;
        this.shippedAt = shippedAt;
        this.canceledAt = canceledAt;
        this.cancelReason = cancelReason;
        this.failedAt = failedAt;
        this.failureReason = failureReason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="recipient")
    public Optional<FulfillmentRecipient> getRecipient() {
        return this.recipient;
    }

    @JsonIgnore
    public Optional<String> getCarrier() {
        if (this.carrier == null) {
            return Optional.empty();
        }
        return this.carrier;
    }

    @JsonIgnore
    public Optional<String> getShippingNote() {
        if (this.shippingNote == null) {
            return Optional.empty();
        }
        return this.shippingNote;
    }

    @JsonIgnore
    public Optional<String> getShippingType() {
        if (this.shippingType == null) {
            return Optional.empty();
        }
        return this.shippingType;
    }

    @JsonIgnore
    public Optional<String> getTrackingNumber() {
        if (this.trackingNumber == null) {
            return Optional.empty();
        }
        return this.trackingNumber;
    }

    @JsonIgnore
    public Optional<String> getTrackingUrl() {
        if (this.trackingUrl == null) {
            return Optional.empty();
        }
        return this.trackingUrl;
    }

    @JsonProperty(value="placed_at")
    public Optional<String> getPlacedAt() {
        return this.placedAt;
    }

    @JsonProperty(value="in_progress_at")
    public Optional<String> getInProgressAt() {
        return this.inProgressAt;
    }

    @JsonProperty(value="packaged_at")
    public Optional<String> getPackagedAt() {
        return this.packagedAt;
    }

    @JsonIgnore
    public Optional<String> getExpectedShippedAt() {
        if (this.expectedShippedAt == null) {
            return Optional.empty();
        }
        return this.expectedShippedAt;
    }

    @JsonProperty(value="shipped_at")
    public Optional<String> getShippedAt() {
        return this.shippedAt;
    }

    @JsonIgnore
    public Optional<String> getCanceledAt() {
        if (this.canceledAt == null) {
            return Optional.empty();
        }
        return this.canceledAt;
    }

    @JsonIgnore
    public Optional<String> getCancelReason() {
        if (this.cancelReason == null) {
            return Optional.empty();
        }
        return this.cancelReason;
    }

    @JsonProperty(value="failed_at")
    public Optional<String> getFailedAt() {
        return this.failedAt;
    }

    @JsonIgnore
    public Optional<String> getFailureReason() {
        if (this.failureReason == null) {
            return Optional.empty();
        }
        return this.failureReason;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="carrier")
    private Optional<String> _getCarrier() {
        return this.carrier;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipping_note")
    private Optional<String> _getShippingNote() {
        return this.shippingNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipping_type")
    private Optional<String> _getShippingType() {
        return this.shippingType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tracking_number")
    private Optional<String> _getTrackingNumber() {
        return this.trackingNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tracking_url")
    private Optional<String> _getTrackingUrl() {
        return this.trackingUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="expected_shipped_at")
    private Optional<String> _getExpectedShippedAt() {
        return this.expectedShippedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="canceled_at")
    private Optional<String> _getCanceledAt() {
        return this.canceledAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cancel_reason")
    private Optional<String> _getCancelReason() {
        return this.cancelReason;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="failure_reason")
    private Optional<String> _getFailureReason() {
        return this.failureReason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FulfillmentShipmentDetails && this.equalTo((FulfillmentShipmentDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FulfillmentShipmentDetails other) {
        return this.recipient.equals(other.recipient) && this.carrier.equals(other.carrier) && this.shippingNote.equals(other.shippingNote) && this.shippingType.equals(other.shippingType) && this.trackingNumber.equals(other.trackingNumber) && this.trackingUrl.equals(other.trackingUrl) && this.placedAt.equals(other.placedAt) && this.inProgressAt.equals(other.inProgressAt) && this.packagedAt.equals(other.packagedAt) && this.expectedShippedAt.equals(other.expectedShippedAt) && this.shippedAt.equals(other.shippedAt) && this.canceledAt.equals(other.canceledAt) && this.cancelReason.equals(other.cancelReason) && this.failedAt.equals(other.failedAt) && this.failureReason.equals(other.failureReason);
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.carrier, this.shippingNote, this.shippingType, this.trackingNumber, this.trackingUrl, this.placedAt, this.inProgressAt, this.packagedAt, this.expectedShippedAt, this.shippedAt, this.canceledAt, this.cancelReason, this.failedAt, this.failureReason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<FulfillmentRecipient> recipient = Optional.empty();
        private Optional<String> carrier = Optional.empty();
        private Optional<String> shippingNote = Optional.empty();
        private Optional<String> shippingType = Optional.empty();
        private Optional<String> trackingNumber = Optional.empty();
        private Optional<String> trackingUrl = Optional.empty();
        private Optional<String> placedAt = Optional.empty();
        private Optional<String> inProgressAt = Optional.empty();
        private Optional<String> packagedAt = Optional.empty();
        private Optional<String> expectedShippedAt = Optional.empty();
        private Optional<String> shippedAt = Optional.empty();
        private Optional<String> canceledAt = Optional.empty();
        private Optional<String> cancelReason = Optional.empty();
        private Optional<String> failedAt = Optional.empty();
        private Optional<String> failureReason = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FulfillmentShipmentDetails other) {
            this.recipient(other.getRecipient());
            this.carrier(other.getCarrier());
            this.shippingNote(other.getShippingNote());
            this.shippingType(other.getShippingType());
            this.trackingNumber(other.getTrackingNumber());
            this.trackingUrl(other.getTrackingUrl());
            this.placedAt(other.getPlacedAt());
            this.inProgressAt(other.getInProgressAt());
            this.packagedAt(other.getPackagedAt());
            this.expectedShippedAt(other.getExpectedShippedAt());
            this.shippedAt(other.getShippedAt());
            this.canceledAt(other.getCanceledAt());
            this.cancelReason(other.getCancelReason());
            this.failedAt(other.getFailedAt());
            this.failureReason(other.getFailureReason());
            return this;
        }

        @JsonSetter(value="recipient", nulls=Nulls.SKIP)
        public Builder recipient(Optional<FulfillmentRecipient> recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder recipient(FulfillmentRecipient recipient) {
            this.recipient = Optional.ofNullable(recipient);
            return this;
        }

        @JsonSetter(value="carrier", nulls=Nulls.SKIP)
        public Builder carrier(Optional<String> carrier) {
            this.carrier = carrier;
            return this;
        }

        public Builder carrier(String carrier) {
            this.carrier = Optional.ofNullable(carrier);
            return this;
        }

        public Builder carrier(Nullable<String> carrier) {
            this.carrier = carrier.isNull() ? null : (carrier.isEmpty() ? Optional.empty() : Optional.of(carrier.get()));
            return this;
        }

        @JsonSetter(value="shipping_note", nulls=Nulls.SKIP)
        public Builder shippingNote(Optional<String> shippingNote) {
            this.shippingNote = shippingNote;
            return this;
        }

        public Builder shippingNote(String shippingNote) {
            this.shippingNote = Optional.ofNullable(shippingNote);
            return this;
        }

        public Builder shippingNote(Nullable<String> shippingNote) {
            this.shippingNote = shippingNote.isNull() ? null : (shippingNote.isEmpty() ? Optional.empty() : Optional.of(shippingNote.get()));
            return this;
        }

        @JsonSetter(value="shipping_type", nulls=Nulls.SKIP)
        public Builder shippingType(Optional<String> shippingType) {
            this.shippingType = shippingType;
            return this;
        }

        public Builder shippingType(String shippingType) {
            this.shippingType = Optional.ofNullable(shippingType);
            return this;
        }

        public Builder shippingType(Nullable<String> shippingType) {
            this.shippingType = shippingType.isNull() ? null : (shippingType.isEmpty() ? Optional.empty() : Optional.of(shippingType.get()));
            return this;
        }

        @JsonSetter(value="tracking_number", nulls=Nulls.SKIP)
        public Builder trackingNumber(Optional<String> trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }

        public Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = Optional.ofNullable(trackingNumber);
            return this;
        }

        public Builder trackingNumber(Nullable<String> trackingNumber) {
            this.trackingNumber = trackingNumber.isNull() ? null : (trackingNumber.isEmpty() ? Optional.empty() : Optional.of(trackingNumber.get()));
            return this;
        }

        @JsonSetter(value="tracking_url", nulls=Nulls.SKIP)
        public Builder trackingUrl(Optional<String> trackingUrl) {
            this.trackingUrl = trackingUrl;
            return this;
        }

        public Builder trackingUrl(String trackingUrl) {
            this.trackingUrl = Optional.ofNullable(trackingUrl);
            return this;
        }

        public Builder trackingUrl(Nullable<String> trackingUrl) {
            this.trackingUrl = trackingUrl.isNull() ? null : (trackingUrl.isEmpty() ? Optional.empty() : Optional.of(trackingUrl.get()));
            return this;
        }

        @JsonSetter(value="placed_at", nulls=Nulls.SKIP)
        public Builder placedAt(Optional<String> placedAt) {
            this.placedAt = placedAt;
            return this;
        }

        public Builder placedAt(String placedAt) {
            this.placedAt = Optional.ofNullable(placedAt);
            return this;
        }

        @JsonSetter(value="in_progress_at", nulls=Nulls.SKIP)
        public Builder inProgressAt(Optional<String> inProgressAt) {
            this.inProgressAt = inProgressAt;
            return this;
        }

        public Builder inProgressAt(String inProgressAt) {
            this.inProgressAt = Optional.ofNullable(inProgressAt);
            return this;
        }

        @JsonSetter(value="packaged_at", nulls=Nulls.SKIP)
        public Builder packagedAt(Optional<String> packagedAt) {
            this.packagedAt = packagedAt;
            return this;
        }

        public Builder packagedAt(String packagedAt) {
            this.packagedAt = Optional.ofNullable(packagedAt);
            return this;
        }

        @JsonSetter(value="expected_shipped_at", nulls=Nulls.SKIP)
        public Builder expectedShippedAt(Optional<String> expectedShippedAt) {
            this.expectedShippedAt = expectedShippedAt;
            return this;
        }

        public Builder expectedShippedAt(String expectedShippedAt) {
            this.expectedShippedAt = Optional.ofNullable(expectedShippedAt);
            return this;
        }

        public Builder expectedShippedAt(Nullable<String> expectedShippedAt) {
            this.expectedShippedAt = expectedShippedAt.isNull() ? null : (expectedShippedAt.isEmpty() ? Optional.empty() : Optional.of(expectedShippedAt.get()));
            return this;
        }

        @JsonSetter(value="shipped_at", nulls=Nulls.SKIP)
        public Builder shippedAt(Optional<String> shippedAt) {
            this.shippedAt = shippedAt;
            return this;
        }

        public Builder shippedAt(String shippedAt) {
            this.shippedAt = Optional.ofNullable(shippedAt);
            return this;
        }

        @JsonSetter(value="canceled_at", nulls=Nulls.SKIP)
        public Builder canceledAt(Optional<String> canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder canceledAt(String canceledAt) {
            this.canceledAt = Optional.ofNullable(canceledAt);
            return this;
        }

        public Builder canceledAt(Nullable<String> canceledAt) {
            this.canceledAt = canceledAt.isNull() ? null : (canceledAt.isEmpty() ? Optional.empty() : Optional.of(canceledAt.get()));
            return this;
        }

        @JsonSetter(value="cancel_reason", nulls=Nulls.SKIP)
        public Builder cancelReason(Optional<String> cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = Optional.ofNullable(cancelReason);
            return this;
        }

        public Builder cancelReason(Nullable<String> cancelReason) {
            this.cancelReason = cancelReason.isNull() ? null : (cancelReason.isEmpty() ? Optional.empty() : Optional.of(cancelReason.get()));
            return this;
        }

        @JsonSetter(value="failed_at", nulls=Nulls.SKIP)
        public Builder failedAt(Optional<String> failedAt) {
            this.failedAt = failedAt;
            return this;
        }

        public Builder failedAt(String failedAt) {
            this.failedAt = Optional.ofNullable(failedAt);
            return this;
        }

        @JsonSetter(value="failure_reason", nulls=Nulls.SKIP)
        public Builder failureReason(Optional<String> failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.failureReason = Optional.ofNullable(failureReason);
            return this;
        }

        public Builder failureReason(Nullable<String> failureReason) {
            this.failureReason = failureReason.isNull() ? null : (failureReason.isEmpty() ? Optional.empty() : Optional.of(failureReason.get()));
            return this;
        }

        public FulfillmentShipmentDetails build() {
            return new FulfillmentShipmentDetails(this.recipient, this.carrier, this.shippingNote, this.shippingType, this.trackingNumber, this.trackingUrl, this.placedAt, this.inProgressAt, this.packagedAt, this.expectedShippedAt, this.shippedAt, this.canceledAt, this.cancelReason, this.failedAt, this.failureReason, this.additionalProperties);
        }
    }
}

