/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FulfillmentRecipient {
    private final Optional<String> customerId;
    private final Optional<String> displayName;
    private final Optional<String> emailAddress;
    private final Optional<String> phoneNumber;
    private final Optional<Address> address;
    private final Map<String, Object> additionalProperties;

    private FulfillmentRecipient(Optional<String> customerId, Optional<String> displayName, Optional<String> emailAddress, Optional<String> phoneNumber, Optional<Address> address, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.address = address;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonIgnore
    public Optional<String> getDisplayName() {
        if (this.displayName == null) {
            return Optional.empty();
        }
        return this.displayName;
    }

    @JsonIgnore
    public Optional<String> getEmailAddress() {
        if (this.emailAddress == null) {
            return Optional.empty();
        }
        return this.emailAddress;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        if (this.phoneNumber == null) {
            return Optional.empty();
        }
        return this.phoneNumber;
    }

    @JsonProperty(value="address")
    public Optional<Address> getAddress() {
        return this.address;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="display_name")
    private Optional<String> _getDisplayName() {
        return this.displayName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address")
    private Optional<String> _getEmailAddress() {
        return this.emailAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number")
    private Optional<String> _getPhoneNumber() {
        return this.phoneNumber;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FulfillmentRecipient && this.equalTo((FulfillmentRecipient)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FulfillmentRecipient other) {
        return this.customerId.equals(other.customerId) && this.displayName.equals(other.displayName) && this.emailAddress.equals(other.emailAddress) && this.phoneNumber.equals(other.phoneNumber) && this.address.equals(other.address);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.displayName, this.emailAddress, this.phoneNumber, this.address);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> customerId = Optional.empty();
        private Optional<String> displayName = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<Address> address = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FulfillmentRecipient other) {
            this.customerId(other.getCustomerId());
            this.displayName(other.getDisplayName());
            this.emailAddress(other.getEmailAddress());
            this.phoneNumber(other.getPhoneNumber());
            this.address(other.getAddress());
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        public Builder customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @JsonSetter(value="display_name", nulls=Nulls.SKIP)
        public Builder displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = Optional.ofNullable(displayName);
            return this;
        }

        public Builder displayName(Nullable<String> displayName) {
            this.displayName = displayName.isNull() ? null : (displayName.isEmpty() ? Optional.empty() : Optional.of(displayName.get()));
            return this;
        }

        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public Builder emailAddress(Optional<String> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        public Builder emailAddress(Nullable<String> emailAddress) {
            this.emailAddress = emailAddress.isNull() ? null : (emailAddress.isEmpty() ? Optional.empty() : Optional.of(emailAddress.get()));
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumber(Nullable<String> phoneNumber) {
            this.phoneNumber = phoneNumber.isNull() ? null : (phoneNumber.isEmpty() ? Optional.empty() : Optional.of(phoneNumber.get()));
            return this;
        }

        @JsonSetter(value="address", nulls=Nulls.SKIP)
        public Builder address(Optional<Address> address) {
            this.address = address;
            return this;
        }

        public Builder address(Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        public FulfillmentRecipient build() {
            return new FulfillmentRecipient(this.customerId, this.displayName, this.emailAddress, this.phoneNumber, this.address, this.additionalProperties);
        }
    }
}

