/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventTypeMetadata {
    private final Optional<String> eventType;
    private final Optional<String> apiVersionIntroduced;
    private final Optional<String> releaseStatus;
    private final Map<String, Object> additionalProperties;

    private EventTypeMetadata(Optional<String> eventType, Optional<String> apiVersionIntroduced, Optional<String> releaseStatus, Map<String, Object> additionalProperties) {
        this.eventType = eventType;
        this.apiVersionIntroduced = apiVersionIntroduced;
        this.releaseStatus = releaseStatus;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="event_type")
    public Optional<String> getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="api_version_introduced")
    public Optional<String> getApiVersionIntroduced() {
        return this.apiVersionIntroduced;
    }

    @JsonProperty(value="release_status")
    public Optional<String> getReleaseStatus() {
        return this.releaseStatus;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventTypeMetadata && this.equalTo((EventTypeMetadata)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventTypeMetadata other) {
        return this.eventType.equals(other.eventType) && this.apiVersionIntroduced.equals(other.apiVersionIntroduced) && this.releaseStatus.equals(other.releaseStatus);
    }

    public int hashCode() {
        return Objects.hash(this.eventType, this.apiVersionIntroduced, this.releaseStatus);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> eventType = Optional.empty();
        private Optional<String> apiVersionIntroduced = Optional.empty();
        private Optional<String> releaseStatus = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EventTypeMetadata other) {
            this.eventType(other.getEventType());
            this.apiVersionIntroduced(other.getApiVersionIntroduced());
            this.releaseStatus(other.getReleaseStatus());
            return this;
        }

        @JsonSetter(value="event_type", nulls=Nulls.SKIP)
        public Builder eventType(Optional<String> eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder eventType(String eventType) {
            this.eventType = Optional.ofNullable(eventType);
            return this;
        }

        @JsonSetter(value="api_version_introduced", nulls=Nulls.SKIP)
        public Builder apiVersionIntroduced(Optional<String> apiVersionIntroduced) {
            this.apiVersionIntroduced = apiVersionIntroduced;
            return this;
        }

        public Builder apiVersionIntroduced(String apiVersionIntroduced) {
            this.apiVersionIntroduced = Optional.ofNullable(apiVersionIntroduced);
            return this;
        }

        @JsonSetter(value="release_status", nulls=Nulls.SKIP)
        public Builder releaseStatus(Optional<String> releaseStatus) {
            this.releaseStatus = releaseStatus;
            return this;
        }

        public Builder releaseStatus(String releaseStatus) {
            this.releaseStatus = Optional.ofNullable(releaseStatus);
            return this;
        }

        public EventTypeMetadata build() {
            return new EventTypeMetadata(this.eventType, this.apiVersionIntroduced, this.releaseStatus, this.additionalProperties);
        }
    }
}

