/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventMetadata {
    private final Optional<String> eventId;
    private final Optional<String> apiVersion;
    private final Map<String, Object> additionalProperties;

    private EventMetadata(Optional<String> eventId, Optional<String> apiVersion, Map<String, Object> additionalProperties) {
        this.eventId = eventId;
        this.apiVersion = apiVersion;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getEventId() {
        if (this.eventId == null) {
            return Optional.empty();
        }
        return this.eventId;
    }

    @JsonIgnore
    public Optional<String> getApiVersion() {
        if (this.apiVersion == null) {
            return Optional.empty();
        }
        return this.apiVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="event_id")
    private Optional<String> _getEventId() {
        return this.eventId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="api_version")
    private Optional<String> _getApiVersion() {
        return this.apiVersion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventMetadata && this.equalTo((EventMetadata)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventMetadata other) {
        return this.eventId.equals(other.eventId) && this.apiVersion.equals(other.apiVersion);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.apiVersion);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> eventId = Optional.empty();
        private Optional<String> apiVersion = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EventMetadata other) {
            this.eventId(other.getEventId());
            this.apiVersion(other.getApiVersion());
            return this;
        }

        @JsonSetter(value="event_id", nulls=Nulls.SKIP)
        public Builder eventId(Optional<String> eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = Optional.ofNullable(eventId);
            return this;
        }

        public Builder eventId(Nullable<String> eventId) {
            this.eventId = eventId.isNull() ? null : (eventId.isEmpty() ? Optional.empty() : Optional.of(eventId.get()));
            return this;
        }

        @JsonSetter(value="api_version", nulls=Nulls.SKIP)
        public Builder apiVersion(Optional<String> apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = Optional.ofNullable(apiVersion);
            return this;
        }

        public Builder apiVersion(Nullable<String> apiVersion) {
            this.apiVersion = apiVersion.isNull() ? null : (apiVersion.isEmpty() ? Optional.empty() : Optional.of(apiVersion.get()));
            return this;
        }

        public EventMetadata build() {
            return new EventMetadata(this.eventId, this.apiVersion, this.additionalProperties);
        }
    }
}

