/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class ErrorCategory {
    public static final ErrorCategory RATE_LIMIT_ERROR = new ErrorCategory(Value.RATE_LIMIT_ERROR, "RATE_LIMIT_ERROR");
    public static final ErrorCategory REFUND_ERROR = new ErrorCategory(Value.REFUND_ERROR, "REFUND_ERROR");
    public static final ErrorCategory PAYMENT_METHOD_ERROR = new ErrorCategory(Value.PAYMENT_METHOD_ERROR, "PAYMENT_METHOD_ERROR");
    public static final ErrorCategory INVALID_REQUEST_ERROR = new ErrorCategory(Value.INVALID_REQUEST_ERROR, "INVALID_REQUEST_ERROR");
    public static final ErrorCategory EXTERNAL_VENDOR_ERROR = new ErrorCategory(Value.EXTERNAL_VENDOR_ERROR, "EXTERNAL_VENDOR_ERROR");
    public static final ErrorCategory API_ERROR = new ErrorCategory(Value.API_ERROR, "API_ERROR");
    public static final ErrorCategory AUTHENTICATION_ERROR = new ErrorCategory(Value.AUTHENTICATION_ERROR, "AUTHENTICATION_ERROR");
    public static final ErrorCategory MERCHANT_SUBSCRIPTION_ERROR = new ErrorCategory(Value.MERCHANT_SUBSCRIPTION_ERROR, "MERCHANT_SUBSCRIPTION_ERROR");
    private final Value value;
    private final String string;

    ErrorCategory(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ErrorCategory && this.string.equals(((ErrorCategory)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case RATE_LIMIT_ERROR: {
                return visitor.visitRateLimitError();
            }
            case REFUND_ERROR: {
                return visitor.visitRefundError();
            }
            case PAYMENT_METHOD_ERROR: {
                return visitor.visitPaymentMethodError();
            }
            case INVALID_REQUEST_ERROR: {
                return visitor.visitInvalidRequestError();
            }
            case EXTERNAL_VENDOR_ERROR: {
                return visitor.visitExternalVendorError();
            }
            case API_ERROR: {
                return visitor.visitApiError();
            }
            case AUTHENTICATION_ERROR: {
                return visitor.visitAuthenticationError();
            }
            case MERCHANT_SUBSCRIPTION_ERROR: {
                return visitor.visitMerchantSubscriptionError();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static ErrorCategory valueOf(String value) {
        switch (value) {
            case "RATE_LIMIT_ERROR": {
                return RATE_LIMIT_ERROR;
            }
            case "REFUND_ERROR": {
                return REFUND_ERROR;
            }
            case "PAYMENT_METHOD_ERROR": {
                return PAYMENT_METHOD_ERROR;
            }
            case "INVALID_REQUEST_ERROR": {
                return INVALID_REQUEST_ERROR;
            }
            case "EXTERNAL_VENDOR_ERROR": {
                return EXTERNAL_VENDOR_ERROR;
            }
            case "API_ERROR": {
                return API_ERROR;
            }
            case "AUTHENTICATION_ERROR": {
                return AUTHENTICATION_ERROR;
            }
            case "MERCHANT_SUBSCRIPTION_ERROR": {
                return MERCHANT_SUBSCRIPTION_ERROR;
            }
        }
        return new ErrorCategory(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitApiError();

        public T visitAuthenticationError();

        public T visitInvalidRequestError();

        public T visitRateLimitError();

        public T visitPaymentMethodError();

        public T visitRefundError();

        public T visitMerchantSubscriptionError();

        public T visitExternalVendorError();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        API_ERROR,
        AUTHENTICATION_ERROR,
        INVALID_REQUEST_ERROR,
        RATE_LIMIT_ERROR,
        PAYMENT_METHOD_ERROR,
        REFUND_ERROR,
        MERCHANT_SUBSCRIPTION_ERROR,
        EXTERNAL_VENDOR_ERROR,
        UNKNOWN;

    }
}

