/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ErrorCategory;
import com.squareup.square.types.ErrorCode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Error {
    private final ErrorCategory category;
    private final ErrorCode code;
    private final Optional<String> detail;
    private final Optional<String> field;
    private final Map<String, Object> additionalProperties;

    private Error(ErrorCategory category, ErrorCode code, Optional<String> detail, Optional<String> field, Map<String, Object> additionalProperties) {
        this.category = category;
        this.code = code;
        this.detail = detail;
        this.field = field;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="category")
    public ErrorCategory getCategory() {
        return this.category;
    }

    @JsonProperty(value="code")
    public ErrorCode getCode() {
        return this.code;
    }

    @JsonProperty(value="detail")
    public Optional<String> getDetail() {
        return this.detail;
    }

    @JsonProperty(value="field")
    public Optional<String> getField() {
        return this.field;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Error && this.equalTo((Error)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Error other) {
        return this.category.equals(other.category) && this.code.equals(other.code) && this.detail.equals(other.detail) && this.field.equals(other.field);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.code, this.detail, this.field);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CategoryStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CategoryStage,
    CodeStage,
    _FinalStage {
        private ErrorCategory category;
        private ErrorCode code;
        private Optional<String> field = Optional.empty();
        private Optional<String> detail = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Error other) {
            this.category(other.getCategory());
            this.code(other.getCode());
            this.detail(other.getDetail());
            this.field(other.getField());
            return this;
        }

        @Override
        @JsonSetter(value="category")
        public CodeStage category(@NotNull ErrorCategory category) {
            this.category = Objects.requireNonNull(category, "category must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="code")
        public _FinalStage code(@NotNull ErrorCode code) {
            this.code = Objects.requireNonNull(code, "code must not be null");
            return this;
        }

        @Override
        public _FinalStage field(String field) {
            this.field = Optional.ofNullable(field);
            return this;
        }

        @Override
        @JsonSetter(value="field", nulls=Nulls.SKIP)
        public _FinalStage field(Optional<String> field) {
            this.field = field;
            return this;
        }

        @Override
        public _FinalStage detail(String detail) {
            this.detail = Optional.ofNullable(detail);
            return this;
        }

        @Override
        @JsonSetter(value="detail", nulls=Nulls.SKIP)
        public _FinalStage detail(Optional<String> detail) {
            this.detail = detail;
            return this;
        }

        @Override
        public Error build() {
            return new Error(this.category, this.code, this.detail, this.field, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Error build();

        public _FinalStage detail(Optional<String> var1);

        public _FinalStage detail(String var1);

        public _FinalStage field(Optional<String> var1);

        public _FinalStage field(String var1);
    }

    public static interface CodeStage {
        public _FinalStage code(@NotNull ErrorCode var1);
    }

    public static interface CategoryStage {
        public CodeStage category(@NotNull ErrorCategory var1);

        public Builder from(Error var1);
    }
}

