/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.EmployeeStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Employee {
    private final Optional<String> id;
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final Optional<String> email;
    private final Optional<String> phoneNumber;
    private final Optional<List<String>> locationIds;
    private final Optional<EmployeeStatus> status;
    private final Optional<Boolean> isOwner;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private Employee(Optional<String> id, Optional<String> firstName, Optional<String> lastName, Optional<String> email, Optional<String> phoneNumber, Optional<List<String>> locationIds, Optional<EmployeeStatus> status, Optional<Boolean> isOwner, Optional<String> createdAt, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.phoneNumber = phoneNumber;
        this.locationIds = locationIds;
        this.status = status;
        this.isOwner = isOwner;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getFirstName() {
        if (this.firstName == null) {
            return Optional.empty();
        }
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> getLastName() {
        if (this.lastName == null) {
            return Optional.empty();
        }
        return this.lastName;
    }

    @JsonIgnore
    public Optional<String> getEmail() {
        if (this.email == null) {
            return Optional.empty();
        }
        return this.email;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        if (this.phoneNumber == null) {
            return Optional.empty();
        }
        return this.phoneNumber;
    }

    @JsonIgnore
    public Optional<List<String>> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonProperty(value="status")
    public Optional<EmployeeStatus> getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Optional<Boolean> getIsOwner() {
        if (this.isOwner == null) {
            return Optional.empty();
        }
        return this.isOwner;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="first_name")
    private Optional<String> _getFirstName() {
        return this.firstName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_name")
    private Optional<String> _getLastName() {
        return this.lastName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email")
    private Optional<String> _getEmail() {
        return this.email;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number")
    private Optional<String> _getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<List<String>> _getLocationIds() {
        return this.locationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_owner")
    private Optional<Boolean> _getIsOwner() {
        return this.isOwner;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Employee && this.equalTo((Employee)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Employee other) {
        return this.id.equals(other.id) && this.firstName.equals(other.firstName) && this.lastName.equals(other.lastName) && this.email.equals(other.email) && this.phoneNumber.equals(other.phoneNumber) && this.locationIds.equals(other.locationIds) && this.status.equals(other.status) && this.isOwner.equals(other.isOwner) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstName, this.lastName, this.email, this.phoneNumber, this.locationIds, this.status, this.isOwner, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<List<String>> locationIds = Optional.empty();
        private Optional<EmployeeStatus> status = Optional.empty();
        private Optional<Boolean> isOwner = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Employee other) {
            this.id(other.getId());
            this.firstName(other.getFirstName());
            this.lastName(other.getLastName());
            this.email(other.getEmail());
            this.phoneNumber(other.getPhoneNumber());
            this.locationIds(other.getLocationIds());
            this.status(other.getStatus());
            this.isOwner(other.getIsOwner());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="first_name", nulls=Nulls.SKIP)
        public Builder firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Nullable<String> firstName) {
            this.firstName = firstName.isNull() ? null : (firstName.isEmpty() ? Optional.empty() : Optional.of(firstName.get()));
            return this;
        }

        @JsonSetter(value="last_name", nulls=Nulls.SKIP)
        public Builder lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Nullable<String> lastName) {
            this.lastName = lastName.isNull() ? null : (lastName.isEmpty() ? Optional.empty() : Optional.of(lastName.get()));
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Nullable<String> email) {
            this.email = email.isNull() ? null : (email.isEmpty() ? Optional.empty() : Optional.of(email.get()));
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumber(Nullable<String> phoneNumber) {
            this.phoneNumber = phoneNumber.isNull() ? null : (phoneNumber.isEmpty() ? Optional.empty() : Optional.of(phoneNumber.get()));
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        public Builder locationIds(Nullable<List<String>> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<EmployeeStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(EmployeeStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="is_owner", nulls=Nulls.SKIP)
        public Builder isOwner(Optional<Boolean> isOwner) {
            this.isOwner = isOwner;
            return this;
        }

        public Builder isOwner(Boolean isOwner) {
            this.isOwner = Optional.ofNullable(isOwner);
            return this;
        }

        public Builder isOwner(Nullable<Boolean> isOwner) {
            this.isOwner = isOwner.isNull() ? null : (isOwner.isEmpty() ? Optional.empty() : Optional.of(isOwner.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public Employee build() {
            return new Employee(this.id, this.firstName, this.lastName, this.email, this.phoneNumber, this.locationIds, this.status, this.isOwner, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

