/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class DisputeReason {
    public static final DisputeReason CANCELLED = new DisputeReason(Value.CANCELLED, "CANCELLED");
    public static final DisputeReason EMV_LIABILITY_SHIFT = new DisputeReason(Value.EMV_LIABILITY_SHIFT, "EMV_LIABILITY_SHIFT");
    public static final DisputeReason AMOUNT_DIFFERS = new DisputeReason(Value.AMOUNT_DIFFERS, "AMOUNT_DIFFERS");
    public static final DisputeReason DUPLICATE = new DisputeReason(Value.DUPLICATE, "DUPLICATE");
    public static final DisputeReason CUSTOMER_REQUESTS_CREDIT = new DisputeReason(Value.CUSTOMER_REQUESTS_CREDIT, "CUSTOMER_REQUESTS_CREDIT");
    public static final DisputeReason NOT_AS_DESCRIBED = new DisputeReason(Value.NOT_AS_DESCRIBED, "NOT_AS_DESCRIBED");
    public static final DisputeReason PAID_BY_OTHER_MEANS = new DisputeReason(Value.PAID_BY_OTHER_MEANS, "PAID_BY_OTHER_MEANS");
    public static final DisputeReason NOT_RECEIVED = new DisputeReason(Value.NOT_RECEIVED, "NOT_RECEIVED");
    public static final DisputeReason NO_KNOWLEDGE = new DisputeReason(Value.NO_KNOWLEDGE, "NO_KNOWLEDGE");
    private final Value value;
    private final String string;

    DisputeReason(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof DisputeReason && this.string.equals(((DisputeReason)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case CANCELLED: {
                return visitor.visitCancelled();
            }
            case EMV_LIABILITY_SHIFT: {
                return visitor.visitEmvLiabilityShift();
            }
            case AMOUNT_DIFFERS: {
                return visitor.visitAmountDiffers();
            }
            case DUPLICATE: {
                return visitor.visitDuplicate();
            }
            case CUSTOMER_REQUESTS_CREDIT: {
                return visitor.visitCustomerRequestsCredit();
            }
            case NOT_AS_DESCRIBED: {
                return visitor.visitNotAsDescribed();
            }
            case PAID_BY_OTHER_MEANS: {
                return visitor.visitPaidByOtherMeans();
            }
            case NOT_RECEIVED: {
                return visitor.visitNotReceived();
            }
            case NO_KNOWLEDGE: {
                return visitor.visitNoKnowledge();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static DisputeReason valueOf(String value) {
        switch (value) {
            case "CANCELLED": {
                return CANCELLED;
            }
            case "EMV_LIABILITY_SHIFT": {
                return EMV_LIABILITY_SHIFT;
            }
            case "AMOUNT_DIFFERS": {
                return AMOUNT_DIFFERS;
            }
            case "DUPLICATE": {
                return DUPLICATE;
            }
            case "CUSTOMER_REQUESTS_CREDIT": {
                return CUSTOMER_REQUESTS_CREDIT;
            }
            case "NOT_AS_DESCRIBED": {
                return NOT_AS_DESCRIBED;
            }
            case "PAID_BY_OTHER_MEANS": {
                return PAID_BY_OTHER_MEANS;
            }
            case "NOT_RECEIVED": {
                return NOT_RECEIVED;
            }
            case "NO_KNOWLEDGE": {
                return NO_KNOWLEDGE;
            }
        }
        return new DisputeReason(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitAmountDiffers();

        public T visitCancelled();

        public T visitDuplicate();

        public T visitNoKnowledge();

        public T visitNotAsDescribed();

        public T visitNotReceived();

        public T visitPaidByOtherMeans();

        public T visitCustomerRequestsCredit();

        public T visitEmvLiabilityShift();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        AMOUNT_DIFFERS,
        CANCELLED,
        DUPLICATE,
        NO_KNOWLEDGE,
        NOT_AS_DESCRIBED,
        NOT_RECEIVED,
        PAID_BY_OTHER_MEANS,
        CUSTOMER_REQUESTS_CREDIT,
        EMV_LIABILITY_SHIFT,
        UNKNOWN;

    }
}

