/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DisputeEvidenceFile;
import com.squareup.square.types.DisputeEvidenceType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DisputeEvidence {
    private final Optional<String> evidenceId;
    private final Optional<String> id;
    private final Optional<String> disputeId;
    private final Optional<DisputeEvidenceFile> evidenceFile;
    private final Optional<String> evidenceText;
    private final Optional<String> uploadedAt;
    private final Optional<DisputeEvidenceType> evidenceType;
    private final Map<String, Object> additionalProperties;

    private DisputeEvidence(Optional<String> evidenceId, Optional<String> id, Optional<String> disputeId, Optional<DisputeEvidenceFile> evidenceFile, Optional<String> evidenceText, Optional<String> uploadedAt, Optional<DisputeEvidenceType> evidenceType, Map<String, Object> additionalProperties) {
        this.evidenceId = evidenceId;
        this.id = id;
        this.disputeId = disputeId;
        this.evidenceFile = evidenceFile;
        this.evidenceText = evidenceText;
        this.uploadedAt = uploadedAt;
        this.evidenceType = evidenceType;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getEvidenceId() {
        if (this.evidenceId == null) {
            return Optional.empty();
        }
        return this.evidenceId;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getDisputeId() {
        if (this.disputeId == null) {
            return Optional.empty();
        }
        return this.disputeId;
    }

    @JsonProperty(value="evidence_file")
    public Optional<DisputeEvidenceFile> getEvidenceFile() {
        return this.evidenceFile;
    }

    @JsonIgnore
    public Optional<String> getEvidenceText() {
        if (this.evidenceText == null) {
            return Optional.empty();
        }
        return this.evidenceText;
    }

    @JsonIgnore
    public Optional<String> getUploadedAt() {
        if (this.uploadedAt == null) {
            return Optional.empty();
        }
        return this.uploadedAt;
    }

    @JsonProperty(value="evidence_type")
    public Optional<DisputeEvidenceType> getEvidenceType() {
        return this.evidenceType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="evidence_id")
    private Optional<String> _getEvidenceId() {
        return this.evidenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="dispute_id")
    private Optional<String> _getDisputeId() {
        return this.disputeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="evidence_text")
    private Optional<String> _getEvidenceText() {
        return this.evidenceText;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uploaded_at")
    private Optional<String> _getUploadedAt() {
        return this.uploadedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DisputeEvidence && this.equalTo((DisputeEvidence)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DisputeEvidence other) {
        return this.evidenceId.equals(other.evidenceId) && this.id.equals(other.id) && this.disputeId.equals(other.disputeId) && this.evidenceFile.equals(other.evidenceFile) && this.evidenceText.equals(other.evidenceText) && this.uploadedAt.equals(other.uploadedAt) && this.evidenceType.equals(other.evidenceType);
    }

    public int hashCode() {
        return Objects.hash(this.evidenceId, this.id, this.disputeId, this.evidenceFile, this.evidenceText, this.uploadedAt, this.evidenceType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> evidenceId = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> disputeId = Optional.empty();
        private Optional<DisputeEvidenceFile> evidenceFile = Optional.empty();
        private Optional<String> evidenceText = Optional.empty();
        private Optional<String> uploadedAt = Optional.empty();
        private Optional<DisputeEvidenceType> evidenceType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DisputeEvidence other) {
            this.evidenceId(other.getEvidenceId());
            this.id(other.getId());
            this.disputeId(other.getDisputeId());
            this.evidenceFile(other.getEvidenceFile());
            this.evidenceText(other.getEvidenceText());
            this.uploadedAt(other.getUploadedAt());
            this.evidenceType(other.getEvidenceType());
            return this;
        }

        @JsonSetter(value="evidence_id", nulls=Nulls.SKIP)
        public Builder evidenceId(Optional<String> evidenceId) {
            this.evidenceId = evidenceId;
            return this;
        }

        public Builder evidenceId(String evidenceId) {
            this.evidenceId = Optional.ofNullable(evidenceId);
            return this;
        }

        public Builder evidenceId(Nullable<String> evidenceId) {
            this.evidenceId = evidenceId.isNull() ? null : (evidenceId.isEmpty() ? Optional.empty() : Optional.of(evidenceId.get()));
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="dispute_id", nulls=Nulls.SKIP)
        public Builder disputeId(Optional<String> disputeId) {
            this.disputeId = disputeId;
            return this;
        }

        public Builder disputeId(String disputeId) {
            this.disputeId = Optional.ofNullable(disputeId);
            return this;
        }

        public Builder disputeId(Nullable<String> disputeId) {
            this.disputeId = disputeId.isNull() ? null : (disputeId.isEmpty() ? Optional.empty() : Optional.of(disputeId.get()));
            return this;
        }

        @JsonSetter(value="evidence_file", nulls=Nulls.SKIP)
        public Builder evidenceFile(Optional<DisputeEvidenceFile> evidenceFile) {
            this.evidenceFile = evidenceFile;
            return this;
        }

        public Builder evidenceFile(DisputeEvidenceFile evidenceFile) {
            this.evidenceFile = Optional.ofNullable(evidenceFile);
            return this;
        }

        @JsonSetter(value="evidence_text", nulls=Nulls.SKIP)
        public Builder evidenceText(Optional<String> evidenceText) {
            this.evidenceText = evidenceText;
            return this;
        }

        public Builder evidenceText(String evidenceText) {
            this.evidenceText = Optional.ofNullable(evidenceText);
            return this;
        }

        public Builder evidenceText(Nullable<String> evidenceText) {
            this.evidenceText = evidenceText.isNull() ? null : (evidenceText.isEmpty() ? Optional.empty() : Optional.of(evidenceText.get()));
            return this;
        }

        @JsonSetter(value="uploaded_at", nulls=Nulls.SKIP)
        public Builder uploadedAt(Optional<String> uploadedAt) {
            this.uploadedAt = uploadedAt;
            return this;
        }

        public Builder uploadedAt(String uploadedAt) {
            this.uploadedAt = Optional.ofNullable(uploadedAt);
            return this;
        }

        public Builder uploadedAt(Nullable<String> uploadedAt) {
            this.uploadedAt = uploadedAt.isNull() ? null : (uploadedAt.isEmpty() ? Optional.empty() : Optional.of(uploadedAt.get()));
            return this;
        }

        @JsonSetter(value="evidence_type", nulls=Nulls.SKIP)
        public Builder evidenceType(Optional<DisputeEvidenceType> evidenceType) {
            this.evidenceType = evidenceType;
            return this;
        }

        public Builder evidenceType(DisputeEvidenceType evidenceType) {
            this.evidenceType = Optional.ofNullable(evidenceType);
            return this;
        }

        public DisputeEvidence build() {
            return new DisputeEvidence(this.evidenceId, this.id, this.disputeId, this.evidenceFile, this.evidenceText, this.uploadedAt, this.evidenceType, this.additionalProperties);
        }
    }
}

