/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceMetadata {
    private final Optional<String> batteryPercentage;
    private final Optional<String> chargingState;
    private final Optional<String> locationId;
    private final Optional<String> merchantId;
    private final Optional<String> networkConnectionType;
    private final Optional<String> paymentRegion;
    private final Optional<String> serialNumber;
    private final Optional<String> osVersion;
    private final Optional<String> appVersion;
    private final Optional<String> wifiNetworkName;
    private final Optional<String> wifiNetworkStrength;
    private final Optional<String> ipAddress;
    private final Map<String, Object> additionalProperties;

    private DeviceMetadata(Optional<String> batteryPercentage, Optional<String> chargingState, Optional<String> locationId, Optional<String> merchantId, Optional<String> networkConnectionType, Optional<String> paymentRegion, Optional<String> serialNumber, Optional<String> osVersion, Optional<String> appVersion, Optional<String> wifiNetworkName, Optional<String> wifiNetworkStrength, Optional<String> ipAddress, Map<String, Object> additionalProperties) {
        this.batteryPercentage = batteryPercentage;
        this.chargingState = chargingState;
        this.locationId = locationId;
        this.merchantId = merchantId;
        this.networkConnectionType = networkConnectionType;
        this.paymentRegion = paymentRegion;
        this.serialNumber = serialNumber;
        this.osVersion = osVersion;
        this.appVersion = appVersion;
        this.wifiNetworkName = wifiNetworkName;
        this.wifiNetworkStrength = wifiNetworkStrength;
        this.ipAddress = ipAddress;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getBatteryPercentage() {
        if (this.batteryPercentage == null) {
            return Optional.empty();
        }
        return this.batteryPercentage;
    }

    @JsonIgnore
    public Optional<String> getChargingState() {
        if (this.chargingState == null) {
            return Optional.empty();
        }
        return this.chargingState;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getMerchantId() {
        if (this.merchantId == null) {
            return Optional.empty();
        }
        return this.merchantId;
    }

    @JsonIgnore
    public Optional<String> getNetworkConnectionType() {
        if (this.networkConnectionType == null) {
            return Optional.empty();
        }
        return this.networkConnectionType;
    }

    @JsonIgnore
    public Optional<String> getPaymentRegion() {
        if (this.paymentRegion == null) {
            return Optional.empty();
        }
        return this.paymentRegion;
    }

    @JsonIgnore
    public Optional<String> getSerialNumber() {
        if (this.serialNumber == null) {
            return Optional.empty();
        }
        return this.serialNumber;
    }

    @JsonIgnore
    public Optional<String> getOsVersion() {
        if (this.osVersion == null) {
            return Optional.empty();
        }
        return this.osVersion;
    }

    @JsonIgnore
    public Optional<String> getAppVersion() {
        if (this.appVersion == null) {
            return Optional.empty();
        }
        return this.appVersion;
    }

    @JsonIgnore
    public Optional<String> getWifiNetworkName() {
        if (this.wifiNetworkName == null) {
            return Optional.empty();
        }
        return this.wifiNetworkName;
    }

    @JsonIgnore
    public Optional<String> getWifiNetworkStrength() {
        if (this.wifiNetworkStrength == null) {
            return Optional.empty();
        }
        return this.wifiNetworkStrength;
    }

    @JsonIgnore
    public Optional<String> getIpAddress() {
        if (this.ipAddress == null) {
            return Optional.empty();
        }
        return this.ipAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="battery_percentage")
    private Optional<String> _getBatteryPercentage() {
        return this.batteryPercentage;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="charging_state")
    private Optional<String> _getChargingState() {
        return this.chargingState;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="merchant_id")
    private Optional<String> _getMerchantId() {
        return this.merchantId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="network_connection_type")
    private Optional<String> _getNetworkConnectionType() {
        return this.networkConnectionType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_region")
    private Optional<String> _getPaymentRegion() {
        return this.paymentRegion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="serial_number")
    private Optional<String> _getSerialNumber() {
        return this.serialNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="os_version")
    private Optional<String> _getOsVersion() {
        return this.osVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="app_version")
    private Optional<String> _getAppVersion() {
        return this.appVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="wifi_network_name")
    private Optional<String> _getWifiNetworkName() {
        return this.wifiNetworkName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="wifi_network_strength")
    private Optional<String> _getWifiNetworkStrength() {
        return this.wifiNetworkStrength;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ip_address")
    private Optional<String> _getIpAddress() {
        return this.ipAddress;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceMetadata && this.equalTo((DeviceMetadata)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceMetadata other) {
        return this.batteryPercentage.equals(other.batteryPercentage) && this.chargingState.equals(other.chargingState) && this.locationId.equals(other.locationId) && this.merchantId.equals(other.merchantId) && this.networkConnectionType.equals(other.networkConnectionType) && this.paymentRegion.equals(other.paymentRegion) && this.serialNumber.equals(other.serialNumber) && this.osVersion.equals(other.osVersion) && this.appVersion.equals(other.appVersion) && this.wifiNetworkName.equals(other.wifiNetworkName) && this.wifiNetworkStrength.equals(other.wifiNetworkStrength) && this.ipAddress.equals(other.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.batteryPercentage, this.chargingState, this.locationId, this.merchantId, this.networkConnectionType, this.paymentRegion, this.serialNumber, this.osVersion, this.appVersion, this.wifiNetworkName, this.wifiNetworkStrength, this.ipAddress);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> batteryPercentage = Optional.empty();
        private Optional<String> chargingState = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> merchantId = Optional.empty();
        private Optional<String> networkConnectionType = Optional.empty();
        private Optional<String> paymentRegion = Optional.empty();
        private Optional<String> serialNumber = Optional.empty();
        private Optional<String> osVersion = Optional.empty();
        private Optional<String> appVersion = Optional.empty();
        private Optional<String> wifiNetworkName = Optional.empty();
        private Optional<String> wifiNetworkStrength = Optional.empty();
        private Optional<String> ipAddress = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeviceMetadata other) {
            this.batteryPercentage(other.getBatteryPercentage());
            this.chargingState(other.getChargingState());
            this.locationId(other.getLocationId());
            this.merchantId(other.getMerchantId());
            this.networkConnectionType(other.getNetworkConnectionType());
            this.paymentRegion(other.getPaymentRegion());
            this.serialNumber(other.getSerialNumber());
            this.osVersion(other.getOsVersion());
            this.appVersion(other.getAppVersion());
            this.wifiNetworkName(other.getWifiNetworkName());
            this.wifiNetworkStrength(other.getWifiNetworkStrength());
            this.ipAddress(other.getIpAddress());
            return this;
        }

        @JsonSetter(value="battery_percentage", nulls=Nulls.SKIP)
        public Builder batteryPercentage(Optional<String> batteryPercentage) {
            this.batteryPercentage = batteryPercentage;
            return this;
        }

        public Builder batteryPercentage(String batteryPercentage) {
            this.batteryPercentage = Optional.ofNullable(batteryPercentage);
            return this;
        }

        public Builder batteryPercentage(Nullable<String> batteryPercentage) {
            this.batteryPercentage = batteryPercentage.isNull() ? null : (batteryPercentage.isEmpty() ? Optional.empty() : Optional.of(batteryPercentage.get()));
            return this;
        }

        @JsonSetter(value="charging_state", nulls=Nulls.SKIP)
        public Builder chargingState(Optional<String> chargingState) {
            this.chargingState = chargingState;
            return this;
        }

        public Builder chargingState(String chargingState) {
            this.chargingState = Optional.ofNullable(chargingState);
            return this;
        }

        public Builder chargingState(Nullable<String> chargingState) {
            this.chargingState = chargingState.isNull() ? null : (chargingState.isEmpty() ? Optional.empty() : Optional.of(chargingState.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="merchant_id", nulls=Nulls.SKIP)
        public Builder merchantId(Optional<String> merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = Optional.ofNullable(merchantId);
            return this;
        }

        public Builder merchantId(Nullable<String> merchantId) {
            this.merchantId = merchantId.isNull() ? null : (merchantId.isEmpty() ? Optional.empty() : Optional.of(merchantId.get()));
            return this;
        }

        @JsonSetter(value="network_connection_type", nulls=Nulls.SKIP)
        public Builder networkConnectionType(Optional<String> networkConnectionType) {
            this.networkConnectionType = networkConnectionType;
            return this;
        }

        public Builder networkConnectionType(String networkConnectionType) {
            this.networkConnectionType = Optional.ofNullable(networkConnectionType);
            return this;
        }

        public Builder networkConnectionType(Nullable<String> networkConnectionType) {
            this.networkConnectionType = networkConnectionType.isNull() ? null : (networkConnectionType.isEmpty() ? Optional.empty() : Optional.of(networkConnectionType.get()));
            return this;
        }

        @JsonSetter(value="payment_region", nulls=Nulls.SKIP)
        public Builder paymentRegion(Optional<String> paymentRegion) {
            this.paymentRegion = paymentRegion;
            return this;
        }

        public Builder paymentRegion(String paymentRegion) {
            this.paymentRegion = Optional.ofNullable(paymentRegion);
            return this;
        }

        public Builder paymentRegion(Nullable<String> paymentRegion) {
            this.paymentRegion = paymentRegion.isNull() ? null : (paymentRegion.isEmpty() ? Optional.empty() : Optional.of(paymentRegion.get()));
            return this;
        }

        @JsonSetter(value="serial_number", nulls=Nulls.SKIP)
        public Builder serialNumber(Optional<String> serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = Optional.ofNullable(serialNumber);
            return this;
        }

        public Builder serialNumber(Nullable<String> serialNumber) {
            this.serialNumber = serialNumber.isNull() ? null : (serialNumber.isEmpty() ? Optional.empty() : Optional.of(serialNumber.get()));
            return this;
        }

        @JsonSetter(value="os_version", nulls=Nulls.SKIP)
        public Builder osVersion(Optional<String> osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = Optional.ofNullable(osVersion);
            return this;
        }

        public Builder osVersion(Nullable<String> osVersion) {
            this.osVersion = osVersion.isNull() ? null : (osVersion.isEmpty() ? Optional.empty() : Optional.of(osVersion.get()));
            return this;
        }

        @JsonSetter(value="app_version", nulls=Nulls.SKIP)
        public Builder appVersion(Optional<String> appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public Builder appVersion(String appVersion) {
            this.appVersion = Optional.ofNullable(appVersion);
            return this;
        }

        public Builder appVersion(Nullable<String> appVersion) {
            this.appVersion = appVersion.isNull() ? null : (appVersion.isEmpty() ? Optional.empty() : Optional.of(appVersion.get()));
            return this;
        }

        @JsonSetter(value="wifi_network_name", nulls=Nulls.SKIP)
        public Builder wifiNetworkName(Optional<String> wifiNetworkName) {
            this.wifiNetworkName = wifiNetworkName;
            return this;
        }

        public Builder wifiNetworkName(String wifiNetworkName) {
            this.wifiNetworkName = Optional.ofNullable(wifiNetworkName);
            return this;
        }

        public Builder wifiNetworkName(Nullable<String> wifiNetworkName) {
            this.wifiNetworkName = wifiNetworkName.isNull() ? null : (wifiNetworkName.isEmpty() ? Optional.empty() : Optional.of(wifiNetworkName.get()));
            return this;
        }

        @JsonSetter(value="wifi_network_strength", nulls=Nulls.SKIP)
        public Builder wifiNetworkStrength(Optional<String> wifiNetworkStrength) {
            this.wifiNetworkStrength = wifiNetworkStrength;
            return this;
        }

        public Builder wifiNetworkStrength(String wifiNetworkStrength) {
            this.wifiNetworkStrength = Optional.ofNullable(wifiNetworkStrength);
            return this;
        }

        public Builder wifiNetworkStrength(Nullable<String> wifiNetworkStrength) {
            this.wifiNetworkStrength = wifiNetworkStrength.isNull() ? null : (wifiNetworkStrength.isEmpty() ? Optional.empty() : Optional.of(wifiNetworkStrength.get()));
            return this;
        }

        @JsonSetter(value="ip_address", nulls=Nulls.SKIP)
        public Builder ipAddress(Optional<String> ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = Optional.ofNullable(ipAddress);
            return this;
        }

        public Builder ipAddress(Nullable<String> ipAddress) {
            this.ipAddress = ipAddress.isNull() ? null : (ipAddress.isEmpty() ? Optional.empty() : Optional.of(ipAddress.get()));
            return this;
        }

        public DeviceMetadata build() {
            return new DeviceMetadata(this.batteryPercentage, this.chargingState, this.locationId, this.merchantId, this.networkConnectionType, this.paymentRegion, this.serialNumber, this.osVersion, this.appVersion, this.wifiNetworkName, this.wifiNetworkStrength, this.ipAddress, this.additionalProperties);
        }
    }
}

