/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceDetails {
    private final Optional<String> deviceId;
    private final Optional<String> deviceInstallationId;
    private final Optional<String> deviceName;
    private final Map<String, Object> additionalProperties;

    private DeviceDetails(Optional<String> deviceId, Optional<String> deviceInstallationId, Optional<String> deviceName, Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.deviceInstallationId = deviceInstallationId;
        this.deviceName = deviceName;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getDeviceId() {
        if (this.deviceId == null) {
            return Optional.empty();
        }
        return this.deviceId;
    }

    @JsonIgnore
    public Optional<String> getDeviceInstallationId() {
        if (this.deviceInstallationId == null) {
            return Optional.empty();
        }
        return this.deviceInstallationId;
    }

    @JsonIgnore
    public Optional<String> getDeviceName() {
        if (this.deviceName == null) {
            return Optional.empty();
        }
        return this.deviceName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="device_id")
    private Optional<String> _getDeviceId() {
        return this.deviceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="device_installation_id")
    private Optional<String> _getDeviceInstallationId() {
        return this.deviceInstallationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="device_name")
    private Optional<String> _getDeviceName() {
        return this.deviceName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceDetails && this.equalTo((DeviceDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceDetails other) {
        return this.deviceId.equals(other.deviceId) && this.deviceInstallationId.equals(other.deviceInstallationId) && this.deviceName.equals(other.deviceName);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.deviceInstallationId, this.deviceName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> deviceId = Optional.empty();
        private Optional<String> deviceInstallationId = Optional.empty();
        private Optional<String> deviceName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeviceDetails other) {
            this.deviceId(other.getDeviceId());
            this.deviceInstallationId(other.getDeviceInstallationId());
            this.deviceName(other.getDeviceName());
            return this;
        }

        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public Builder deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.ofNullable(deviceId);
            return this;
        }

        public Builder deviceId(Nullable<String> deviceId) {
            this.deviceId = deviceId.isNull() ? null : (deviceId.isEmpty() ? Optional.empty() : Optional.of(deviceId.get()));
            return this;
        }

        @JsonSetter(value="device_installation_id", nulls=Nulls.SKIP)
        public Builder deviceInstallationId(Optional<String> deviceInstallationId) {
            this.deviceInstallationId = deviceInstallationId;
            return this;
        }

        public Builder deviceInstallationId(String deviceInstallationId) {
            this.deviceInstallationId = Optional.ofNullable(deviceInstallationId);
            return this;
        }

        public Builder deviceInstallationId(Nullable<String> deviceInstallationId) {
            this.deviceInstallationId = deviceInstallationId.isNull() ? null : (deviceInstallationId.isEmpty() ? Optional.empty() : Optional.of(deviceInstallationId.get()));
            return this;
        }

        @JsonSetter(value="device_name", nulls=Nulls.SKIP)
        public Builder deviceName(Optional<String> deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = Optional.ofNullable(deviceName);
            return this;
        }

        public Builder deviceName(Nullable<String> deviceName) {
            this.deviceName = deviceName.isNull() ? null : (deviceName.isEmpty() ? Optional.empty() : Optional.of(deviceName.get()));
            return this;
        }

        public DeviceDetails build() {
            return new DeviceDetails(this.deviceId, this.deviceInstallationId, this.deviceName, this.additionalProperties);
        }
    }
}

