/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeviceAttributes {
    private final String type;
    private final String manufacturer;
    private final Optional<String> model;
    private final Optional<String> name;
    private final Optional<String> manufacturersId;
    private final Optional<String> updatedAt;
    private final Optional<String> version;
    private final Optional<String> merchantToken;
    private final Map<String, Object> additionalProperties;

    private DeviceAttributes(String type, String manufacturer, Optional<String> model, Optional<String> name, Optional<String> manufacturersId, Optional<String> updatedAt, Optional<String> version, Optional<String> merchantToken, Map<String, Object> additionalProperties) {
        this.type = type;
        this.manufacturer = manufacturer;
        this.model = model;
        this.name = name;
        this.manufacturersId = manufacturersId;
        this.updatedAt = updatedAt;
        this.version = version;
        this.merchantToken = merchantToken;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="manufacturer")
    public String getManufacturer() {
        return this.manufacturer;
    }

    @JsonIgnore
    public Optional<String> getModel() {
        if (this.model == null) {
            return Optional.empty();
        }
        return this.model;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getManufacturersId() {
        if (this.manufacturersId == null) {
            return Optional.empty();
        }
        return this.manufacturersId;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Optional<String> getMerchantToken() {
        if (this.merchantToken == null) {
            return Optional.empty();
        }
        return this.merchantToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="model")
    private Optional<String> _getModel() {
        return this.model;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="manufacturers_id")
    private Optional<String> _getManufacturersId() {
        return this.manufacturersId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="merchant_token")
    private Optional<String> _getMerchantToken() {
        return this.merchantToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceAttributes && this.equalTo((DeviceAttributes)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceAttributes other) {
        return this.type.equals(other.type) && this.manufacturer.equals(other.manufacturer) && this.model.equals(other.model) && this.name.equals(other.name) && this.manufacturersId.equals(other.manufacturersId) && this.updatedAt.equals(other.updatedAt) && this.version.equals(other.version) && this.merchantToken.equals(other.merchantToken);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.manufacturer, this.model, this.name, this.manufacturersId, this.updatedAt, this.version, this.merchantToken);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    ManufacturerStage,
    _FinalStage {
        private String type;
        private String manufacturer;
        private Optional<String> merchantToken = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> manufacturersId = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> model = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeviceAttributes other) {
            this.type(other.getType());
            this.manufacturer(other.getManufacturer());
            this.model(other.getModel());
            this.name(other.getName());
            this.manufacturersId(other.getManufacturersId());
            this.updatedAt(other.getUpdatedAt());
            this.version(other.getVersion());
            this.merchantToken(other.getMerchantToken());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public ManufacturerStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="manufacturer")
        public _FinalStage manufacturer(@NotNull String manufacturer) {
            this.manufacturer = Objects.requireNonNull(manufacturer, "manufacturer must not be null");
            return this;
        }

        @Override
        public _FinalStage merchantToken(Nullable<String> merchantToken) {
            this.merchantToken = merchantToken.isNull() ? null : (merchantToken.isEmpty() ? Optional.empty() : Optional.of(merchantToken.get()));
            return this;
        }

        @Override
        public _FinalStage merchantToken(String merchantToken) {
            this.merchantToken = Optional.ofNullable(merchantToken);
            return this;
        }

        @Override
        @JsonSetter(value="merchant_token", nulls=Nulls.SKIP)
        public _FinalStage merchantToken(Optional<String> merchantToken) {
            this.merchantToken = merchantToken;
            return this;
        }

        @Override
        public _FinalStage version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<String> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage manufacturersId(Nullable<String> manufacturersId) {
            this.manufacturersId = manufacturersId.isNull() ? null : (manufacturersId.isEmpty() ? Optional.empty() : Optional.of(manufacturersId.get()));
            return this;
        }

        @Override
        public _FinalStage manufacturersId(String manufacturersId) {
            this.manufacturersId = Optional.ofNullable(manufacturersId);
            return this;
        }

        @Override
        @JsonSetter(value="manufacturers_id", nulls=Nulls.SKIP)
        public _FinalStage manufacturersId(Optional<String> manufacturersId) {
            this.manufacturersId = manufacturersId;
            return this;
        }

        @Override
        public _FinalStage name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage model(Nullable<String> model) {
            this.model = model.isNull() ? null : (model.isEmpty() ? Optional.empty() : Optional.of(model.get()));
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public DeviceAttributes build() {
            return new DeviceAttributes(this.type, this.manufacturer, this.model, this.name, this.manufacturersId, this.updatedAt, this.version, this.merchantToken, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeviceAttributes build();

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);

        public _FinalStage model(Nullable<String> var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage name(Nullable<String> var1);

        public _FinalStage manufacturersId(Optional<String> var1);

        public _FinalStage manufacturersId(String var1);

        public _FinalStage manufacturersId(Nullable<String> var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage version(Optional<String> var1);

        public _FinalStage version(String var1);

        public _FinalStage merchantToken(Optional<String> var1);

        public _FinalStage merchantToken(String var1);

        public _FinalStage merchantToken(Nullable<String> var1);
    }

    public static interface ManufacturerStage {
        public _FinalStage manufacturer(@NotNull String var1);
    }

    public static interface TypeStage {
        public ManufacturerStage type(@NotNull String var1);

        public Builder from(DeviceAttributes var1);
    }
}

