/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeletePaymentLinkResponse {
    private final Optional<List<Error>> errors;
    private final Optional<String> id;
    private final Optional<String> cancelledOrderId;
    private final Map<String, Object> additionalProperties;

    private DeletePaymentLinkResponse(Optional<List<Error>> errors, Optional<String> id, Optional<String> cancelledOrderId, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.id = id;
        this.cancelledOrderId = cancelledOrderId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="cancelled_order_id")
    public Optional<String> getCancelledOrderId() {
        return this.cancelledOrderId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeletePaymentLinkResponse && this.equalTo((DeletePaymentLinkResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeletePaymentLinkResponse other) {
        return this.errors.equals(other.errors) && this.id.equals(other.id) && this.cancelledOrderId.equals(other.cancelledOrderId);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.id, this.cancelledOrderId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> cancelledOrderId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DeletePaymentLinkResponse other) {
            this.errors(other.getErrors());
            this.id(other.getId());
            this.cancelledOrderId(other.getCancelledOrderId());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="cancelled_order_id", nulls=Nulls.SKIP)
        public Builder cancelledOrderId(Optional<String> cancelledOrderId) {
            this.cancelledOrderId = cancelledOrderId;
            return this;
        }

        public Builder cancelledOrderId(String cancelledOrderId) {
            this.cancelledOrderId = Optional.ofNullable(cancelledOrderId);
            return this;
        }

        public DeletePaymentLinkResponse build() {
            return new DeletePaymentLinkResponse(this.errors, this.id, this.cancelledOrderId, this.additionalProperties);
        }
    }
}

