/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteInvoicesRequest {
    private final String invoiceId;
    private final Optional<Integer> version;
    private final Map<String, Object> additionalProperties;

    private DeleteInvoicesRequest(String invoiceId, Optional<Integer> version, Map<String, Object> additionalProperties) {
        this.invoiceId = invoiceId;
        this.version = version;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="invoice_id")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonIgnore
    public Optional<Integer> getVersion() {
        if (this.version == null) {
            return Optional.empty();
        }
        return this.version;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="version")
    private Optional<Integer> _getVersion() {
        return this.version;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteInvoicesRequest && this.equalTo((DeleteInvoicesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteInvoicesRequest other) {
        return this.invoiceId.equals(other.invoiceId) && this.version.equals(other.version);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceId, this.version);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InvoiceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InvoiceIdStage,
    _FinalStage {
        private String invoiceId;
        private Optional<Integer> version = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeleteInvoicesRequest other) {
            this.invoiceId(other.getInvoiceId());
            this.version(other.getVersion());
            return this;
        }

        @Override
        @JsonSetter(value="invoice_id")
        public _FinalStage invoiceId(@NotNull String invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId must not be null");
            return this;
        }

        @Override
        public _FinalStage version(Nullable<Integer> version) {
            this.version = version.isNull() ? null : (version.isEmpty() ? Optional.empty() : Optional.of(version.get()));
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public DeleteInvoicesRequest build() {
            return new DeleteInvoicesRequest(this.invoiceId, this.version, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeleteInvoicesRequest build();

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage version(Nullable<Integer> var1);
    }

    public static interface InvoiceIdStage {
        public _FinalStage invoiceId(@NotNull String var1);

        public Builder from(DeleteInvoicesRequest var1);
    }
}

