/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteInvoiceAttachmentRequest {
    private final String invoiceId;
    private final String attachmentId;
    private final Map<String, Object> additionalProperties;

    private DeleteInvoiceAttachmentRequest(String invoiceId, String attachmentId, Map<String, Object> additionalProperties) {
        this.invoiceId = invoiceId;
        this.attachmentId = attachmentId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="invoice_id")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonProperty(value="attachment_id")
    public String getAttachmentId() {
        return this.attachmentId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteInvoiceAttachmentRequest && this.equalTo((DeleteInvoiceAttachmentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteInvoiceAttachmentRequest other) {
        return this.invoiceId.equals(other.invoiceId) && this.attachmentId.equals(other.attachmentId);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceId, this.attachmentId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InvoiceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InvoiceIdStage,
    AttachmentIdStage,
    _FinalStage {
        private String invoiceId;
        private String attachmentId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeleteInvoiceAttachmentRequest other) {
            this.invoiceId(other.getInvoiceId());
            this.attachmentId(other.getAttachmentId());
            return this;
        }

        @Override
        @JsonSetter(value="invoice_id")
        public AttachmentIdStage invoiceId(@NotNull String invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="attachment_id")
        public _FinalStage attachmentId(@NotNull String attachmentId) {
            this.attachmentId = Objects.requireNonNull(attachmentId, "attachmentId must not be null");
            return this;
        }

        @Override
        public DeleteInvoiceAttachmentRequest build() {
            return new DeleteInvoiceAttachmentRequest(this.invoiceId, this.attachmentId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeleteInvoiceAttachmentRequest build();
    }

    public static interface AttachmentIdStage {
        public _FinalStage attachmentId(@NotNull String var1);
    }

    public static interface InvoiceIdStage {
        public AttachmentIdStage invoiceId(@NotNull String var1);

        public Builder from(DeleteInvoiceAttachmentRequest var1);
    }
}

