/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteCustomersRequest {
    private final String customerId;
    private final Optional<Long> version;
    private final Map<String, Object> additionalProperties;

    private DeleteCustomersRequest(String customerId, Optional<Long> version, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.version = version;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public Optional<Long> getVersion() {
        if (this.version == null) {
            return Optional.empty();
        }
        return this.version;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="version")
    private Optional<Long> _getVersion() {
        return this.version;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteCustomersRequest && this.equalTo((DeleteCustomersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteCustomersRequest other) {
        return this.customerId.equals(other.customerId) && this.version.equals(other.version);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.version);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerIdStage,
    _FinalStage {
        private String customerId;
        private Optional<Long> version = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeleteCustomersRequest other) {
            this.customerId(other.getCustomerId());
            this.version(other.getVersion());
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public _FinalStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        public _FinalStage version(Nullable<Long> version) {
            this.version = version.isNull() ? null : (version.isEmpty() ? Optional.empty() : Optional.of(version.get()));
            return this;
        }

        @Override
        public _FinalStage version(Long version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Long> version) {
            this.version = version;
            return this;
        }

        @Override
        public DeleteCustomersRequest build() {
            return new DeleteCustomersRequest(this.customerId, this.version, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeleteCustomersRequest build();

        public _FinalStage version(Optional<Long> var1);

        public _FinalStage version(Long var1);

        public _FinalStage version(Nullable<Long> var1);
    }

    public static interface CustomerIdStage {
        public _FinalStage customerId(@NotNull String var1);

        public Builder from(DeleteCustomersRequest var1);
    }
}

