/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CollectedData;
import com.squareup.square.types.DataCollectionOptionsInputType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataCollectionOptions {
    private final String title;
    private final String body;
    private final DataCollectionOptionsInputType inputType;
    private final Optional<CollectedData> collectedData;
    private final Map<String, Object> additionalProperties;

    private DataCollectionOptions(String title, String body, DataCollectionOptionsInputType inputType, Optional<CollectedData> collectedData, Map<String, Object> additionalProperties) {
        this.title = title;
        this.body = body;
        this.inputType = inputType;
        this.collectedData = collectedData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="input_type")
    public DataCollectionOptionsInputType getInputType() {
        return this.inputType;
    }

    @JsonProperty(value="collected_data")
    public Optional<CollectedData> getCollectedData() {
        return this.collectedData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataCollectionOptions && this.equalTo((DataCollectionOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataCollectionOptions other) {
        return this.title.equals(other.title) && this.body.equals(other.body) && this.inputType.equals(other.inputType) && this.collectedData.equals(other.collectedData);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.inputType, this.collectedData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    BodyStage,
    InputTypeStage,
    _FinalStage {
        private String title;
        private String body;
        private DataCollectionOptionsInputType inputType;
        private Optional<CollectedData> collectedData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DataCollectionOptions other) {
            this.title(other.getTitle());
            this.body(other.getBody());
            this.inputType(other.getInputType());
            this.collectedData(other.getCollectedData());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public BodyStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public InputTypeStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="input_type")
        public _FinalStage inputType(@NotNull DataCollectionOptionsInputType inputType) {
            this.inputType = Objects.requireNonNull(inputType, "inputType must not be null");
            return this;
        }

        @Override
        public _FinalStage collectedData(CollectedData collectedData) {
            this.collectedData = Optional.ofNullable(collectedData);
            return this;
        }

        @Override
        @JsonSetter(value="collected_data", nulls=Nulls.SKIP)
        public _FinalStage collectedData(Optional<CollectedData> collectedData) {
            this.collectedData = collectedData;
            return this;
        }

        @Override
        public DataCollectionOptions build() {
            return new DataCollectionOptions(this.title, this.body, this.inputType, this.collectedData, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DataCollectionOptions build();

        public _FinalStage collectedData(Optional<CollectedData> var1);

        public _FinalStage collectedData(CollectedData var1);
    }

    public static interface InputTypeStage {
        public _FinalStage inputType(@NotNull DataCollectionOptionsInputType var1);
    }

    public static interface BodyStage {
        public InputTypeStage body(@NotNull String var1);
    }

    public static interface TitleStage {
        public BodyStage title(@NotNull String var1);

        public Builder from(DataCollectionOptions var1);
    }
}

