/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerGroup {
    private final Optional<String> id;
    private final String name;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private CustomerGroup(Optional<String> id, String name, Optional<String> createdAt, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerGroup && this.equalTo((CustomerGroup)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerGroup other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CustomerGroup other) {
            this.id(other.getId());
            this.name(other.getName());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public CustomerGroup build() {
            return new CustomerGroup(this.id, this.name, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CustomerGroup build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);

        public Builder from(CustomerGroup var1);
    }
}

