/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerCreationSourceFilter;
import com.squareup.square.types.CustomerCustomAttributeFilters;
import com.squareup.square.types.CustomerTextFilter;
import com.squareup.square.types.FilterValue;
import com.squareup.square.types.TimeRange;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerFilter {
    private final Optional<CustomerCreationSourceFilter> creationSource;
    private final Optional<TimeRange> createdAt;
    private final Optional<TimeRange> updatedAt;
    private final Optional<CustomerTextFilter> emailAddress;
    private final Optional<CustomerTextFilter> phoneNumber;
    private final Optional<CustomerTextFilter> referenceId;
    private final Optional<FilterValue> groupIds;
    private final Optional<CustomerCustomAttributeFilters> customAttribute;
    private final Optional<FilterValue> segmentIds;
    private final Map<String, Object> additionalProperties;

    private CustomerFilter(Optional<CustomerCreationSourceFilter> creationSource, Optional<TimeRange> createdAt, Optional<TimeRange> updatedAt, Optional<CustomerTextFilter> emailAddress, Optional<CustomerTextFilter> phoneNumber, Optional<CustomerTextFilter> referenceId, Optional<FilterValue> groupIds, Optional<CustomerCustomAttributeFilters> customAttribute, Optional<FilterValue> segmentIds, Map<String, Object> additionalProperties) {
        this.creationSource = creationSource;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.referenceId = referenceId;
        this.groupIds = groupIds;
        this.customAttribute = customAttribute;
        this.segmentIds = segmentIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="creation_source")
    public Optional<CustomerCreationSourceFilter> getCreationSource() {
        return this.creationSource;
    }

    @JsonProperty(value="created_at")
    public Optional<TimeRange> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<TimeRange> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="email_address")
    public Optional<CustomerTextFilter> getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="phone_number")
    public Optional<CustomerTextFilter> getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="reference_id")
    public Optional<CustomerTextFilter> getReferenceId() {
        return this.referenceId;
    }

    @JsonProperty(value="group_ids")
    public Optional<FilterValue> getGroupIds() {
        return this.groupIds;
    }

    @JsonProperty(value="custom_attribute")
    public Optional<CustomerCustomAttributeFilters> getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonProperty(value="segment_ids")
    public Optional<FilterValue> getSegmentIds() {
        return this.segmentIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerFilter && this.equalTo((CustomerFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerFilter other) {
        return this.creationSource.equals(other.creationSource) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.emailAddress.equals(other.emailAddress) && this.phoneNumber.equals(other.phoneNumber) && this.referenceId.equals(other.referenceId) && this.groupIds.equals(other.groupIds) && this.customAttribute.equals(other.customAttribute) && this.segmentIds.equals(other.segmentIds);
    }

    public int hashCode() {
        return Objects.hash(this.creationSource, this.createdAt, this.updatedAt, this.emailAddress, this.phoneNumber, this.referenceId, this.groupIds, this.customAttribute, this.segmentIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CustomerCreationSourceFilter> creationSource = Optional.empty();
        private Optional<TimeRange> createdAt = Optional.empty();
        private Optional<TimeRange> updatedAt = Optional.empty();
        private Optional<CustomerTextFilter> emailAddress = Optional.empty();
        private Optional<CustomerTextFilter> phoneNumber = Optional.empty();
        private Optional<CustomerTextFilter> referenceId = Optional.empty();
        private Optional<FilterValue> groupIds = Optional.empty();
        private Optional<CustomerCustomAttributeFilters> customAttribute = Optional.empty();
        private Optional<FilterValue> segmentIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerFilter other) {
            this.creationSource(other.getCreationSource());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.emailAddress(other.getEmailAddress());
            this.phoneNumber(other.getPhoneNumber());
            this.referenceId(other.getReferenceId());
            this.groupIds(other.getGroupIds());
            this.customAttribute(other.getCustomAttribute());
            this.segmentIds(other.getSegmentIds());
            return this;
        }

        @JsonSetter(value="creation_source", nulls=Nulls.SKIP)
        public Builder creationSource(Optional<CustomerCreationSourceFilter> creationSource) {
            this.creationSource = creationSource;
            return this;
        }

        public Builder creationSource(CustomerCreationSourceFilter creationSource) {
            this.creationSource = Optional.ofNullable(creationSource);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<TimeRange> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(TimeRange createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<TimeRange> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(TimeRange updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public Builder emailAddress(Optional<CustomerTextFilter> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder emailAddress(CustomerTextFilter emailAddress) {
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<CustomerTextFilter> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(CustomerTextFilter phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<CustomerTextFilter> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(CustomerTextFilter referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @JsonSetter(value="group_ids", nulls=Nulls.SKIP)
        public Builder groupIds(Optional<FilterValue> groupIds) {
            this.groupIds = groupIds;
            return this;
        }

        public Builder groupIds(FilterValue groupIds) {
            this.groupIds = Optional.ofNullable(groupIds);
            return this;
        }

        @JsonSetter(value="custom_attribute", nulls=Nulls.SKIP)
        public Builder customAttribute(Optional<CustomerCustomAttributeFilters> customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder customAttribute(CustomerCustomAttributeFilters customAttribute) {
            this.customAttribute = Optional.ofNullable(customAttribute);
            return this;
        }

        @JsonSetter(value="segment_ids", nulls=Nulls.SKIP)
        public Builder segmentIds(Optional<FilterValue> segmentIds) {
            this.segmentIds = segmentIds;
            return this;
        }

        public Builder segmentIds(FilterValue segmentIds) {
            this.segmentIds = Optional.ofNullable(segmentIds);
            return this;
        }

        public CustomerFilter build() {
            return new CustomerFilter(this.creationSource, this.createdAt, this.updatedAt, this.emailAddress, this.phoneNumber, this.referenceId, this.groupIds, this.customAttribute, this.segmentIds, this.additionalProperties);
        }
    }
}

