/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerDetails {
    private final Optional<Boolean> customerInitiated;
    private final Optional<Boolean> sellerKeyedIn;
    private final Map<String, Object> additionalProperties;

    private CustomerDetails(Optional<Boolean> customerInitiated, Optional<Boolean> sellerKeyedIn, Map<String, Object> additionalProperties) {
        this.customerInitiated = customerInitiated;
        this.sellerKeyedIn = sellerKeyedIn;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<Boolean> getCustomerInitiated() {
        if (this.customerInitiated == null) {
            return Optional.empty();
        }
        return this.customerInitiated;
    }

    @JsonIgnore
    public Optional<Boolean> getSellerKeyedIn() {
        if (this.sellerKeyedIn == null) {
            return Optional.empty();
        }
        return this.sellerKeyedIn;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_initiated")
    private Optional<Boolean> _getCustomerInitiated() {
        return this.customerInitiated;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="seller_keyed_in")
    private Optional<Boolean> _getSellerKeyedIn() {
        return this.sellerKeyedIn;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerDetails && this.equalTo((CustomerDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerDetails other) {
        return this.customerInitiated.equals(other.customerInitiated) && this.sellerKeyedIn.equals(other.sellerKeyedIn);
    }

    public int hashCode() {
        return Objects.hash(this.customerInitiated, this.sellerKeyedIn);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> customerInitiated = Optional.empty();
        private Optional<Boolean> sellerKeyedIn = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerDetails other) {
            this.customerInitiated(other.getCustomerInitiated());
            this.sellerKeyedIn(other.getSellerKeyedIn());
            return this;
        }

        @JsonSetter(value="customer_initiated", nulls=Nulls.SKIP)
        public Builder customerInitiated(Optional<Boolean> customerInitiated) {
            this.customerInitiated = customerInitiated;
            return this;
        }

        public Builder customerInitiated(Boolean customerInitiated) {
            this.customerInitiated = Optional.ofNullable(customerInitiated);
            return this;
        }

        public Builder customerInitiated(Nullable<Boolean> customerInitiated) {
            this.customerInitiated = customerInitiated.isNull() ? null : (customerInitiated.isEmpty() ? Optional.empty() : Optional.of(customerInitiated.get()));
            return this;
        }

        @JsonSetter(value="seller_keyed_in", nulls=Nulls.SKIP)
        public Builder sellerKeyedIn(Optional<Boolean> sellerKeyedIn) {
            this.sellerKeyedIn = sellerKeyedIn;
            return this;
        }

        public Builder sellerKeyedIn(Boolean sellerKeyedIn) {
            this.sellerKeyedIn = Optional.ofNullable(sellerKeyedIn);
            return this;
        }

        public Builder sellerKeyedIn(Nullable<Boolean> sellerKeyedIn) {
            this.sellerKeyedIn = sellerKeyedIn.isNull() ? null : (sellerKeyedIn.isEmpty() ? Optional.empty() : Optional.of(sellerKeyedIn.get()));
            return this;
        }

        public CustomerDetails build() {
            return new CustomerDetails(this.customerInitiated, this.sellerKeyedIn, this.additionalProperties);
        }
    }
}

